/*********************************************************************
 * Copyright (c) 2004, 2007 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.ui.skynet.widgets;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

/**
 * @author Donald G. Dunne
 */
public class XListDam extends XList implements AttributeWidget {

   private Artifact artifact;
   private AttributeTypeToken attributeType;

   @Override
   public Artifact getArtifact() {
      return artifact;
   }

   public XListDam(String displayLabel) {
      super(displayLabel);
   }

   @Override
   public AttributeTypeToken getAttributeType() {
      return attributeType;
   }

   @Override
   public void refresh() {
      removeAll();
      add(artifact.getAttributesToStringList(attributeType));
      // If you want read-only widget with no selection
      if (!isNoSelect()) {
         super.setSelected(getStoredStrs());
      }
   }

   @Override
   public void setAttributeType(Artifact artifact, AttributeTypeToken attrType) {
      this.artifact = artifact;
      this.attributeType = attrType;
      refresh();
   }

   @Override
   public void saveToArtifact() {
      getArtifact().setAttributeValues(getAttributeType(), getSelectedStrs());
   }

   public Collection<String> getStoredStrs() {
      return getArtifact().getAttributesToStringList(getAttributeType());
   }

   @Override
   public Result isDirty() {
      if (isEditable()) {
         try {
            Collection<String> enteredValues = getSelectedStrs();
            Collection<String> storedValues = getStoredStrs();
            if (!Collections.isEqual(enteredValues, storedValues)) {
               return new Result(true, getAttributeType() + " is dirty");
            }
         } catch (NumberFormatException ex) {
            // do nothing
         }
      }
      return Result.FalseResult;
   }

   @Override
   public void revert() {
      setAttributeType(getArtifact(), getAttributeType());
   }

}
