/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.core.xml.publishing.AbstractElementList;
import org.eclipse.osee.framework.core.xml.publishing.WordElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AbstractElement
implements WordElement {
    private final Map<Class<?>, Object> childMap;
    private boolean closed;
    private final Element element;
    private boolean isLeaf;
    private final boolean isRoot;
    private final WordElement parent;

    AbstractElement(WordElement parent, Element element) {
        this.parent = parent;
        this.element = Objects.requireNonNull(element, "AbstractElement::new, parameter \"element\" cannot be null.");
        this.childMap = new HashMap();
        this.closed = false;
        this.isLeaf = true;
        this.isRoot = Objects.isNull(this.parent);
    }

    void close() {
        if (this.closed) {
            throw new IllegalStateException("AbstractElement::close, the Object has already been closed.");
        }
        this.closed = true;
    }

    @Override
    public <C> Optional<C> getChild(Class<C> childClass) {
        Object child = this.childMap.get(childClass);
        return Optional.ofNullable(child);
    }

    @Override
    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public WordElement getParent() {
        if (this.isRoot) {
            throw new NoSuchElementException("AbstractElement::getParent, WordElement is the root element.");
        }
        return this.parent;
    }

    @Override
    public String getText() {
        return Objects.requireNonNull(this.element.getTextContent(), "AbstractElement::getText, Element text is unexpectedly null.");
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public boolean isRootElement() {
        return this.isRoot;
    }

    <C> void setChild(C child) {
        if (this.closed) {
            throw new IllegalStateException(new StringBuilder(1024).append("AbstractElement::setChild, cannot add childern after Object has been closed.").append("\n").append("   Child Class: ").append(child.getClass().getName()).append("\n").toString());
        }
        Objects.requireNonNull(child, "AbstractElementWithChildern::setChild, the parameter \"child\" cannot be null.");
        if (!(child instanceof AbstractElement) && !(child instanceof AbstractElementList)) {
            throw new IllegalArgumentException(new StringBuilder(1024).append("AbstractElement::setChild, the parameter \"child\" is not of an allowed class.").append("\n").append("   Child Class:     ").append(child.getClass().getName()).append("\n").append("   Allowed Classes: ").append("AbstractElement, AbstractElementList").append("\n").toString());
        }
        Object priorChild = this.childMap.put(child.getClass(), child);
        this.isLeaf = false;
        if (Objects.nonNull(priorChild)) {
            this.childMap.put(child.getClass(), priorChild);
            throw new IllegalStateException(new StringBuilder(1024).append("AbstractElement::setChild, attempt to set a child that has already been set.").append("\n").append("   Child Class: ").append(child.getClass().getName()).append("\n").append("   Prior Child: ").append(priorChild).append("\n").append("   Child:       ").append(child).append("\n").toString());
        }
    }
}

