/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;
import org.eclipse.osee.framework.logging.OseeLog;

public class WordMLProducer {
    public static final String RGB_RED = "FF0000";
    public static final String RGB_GREEN = "00FF00";
    public static final String RGB_BLUE = "0000FF";
    private static final String FILE_NAME = "fileName";
    public static final String LISTNUM_FIELD_HEAD = "<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>";
    public static final String LISTNUM_FIELD_TAIL = "<w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM  \\l 1 \\s 0 </w:instrText></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"end\"/><wx:t wx:val=\"1.\"/></w:r>";
    public static final String LISTNUM_FIELD_TAIL_REG_EXP = "<w:r(>| .*?>)<w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r(>| .*?>)<w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM \"listreset\"";
    public static final String LISTNUM_FIELD = "<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM  \\l 1 \\s 0 </w:instrText></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"end\"/><wx:t wx:val=\"1.\"/></w:r>";
    private static final String SUB_DOC = "<wx:sect><w:p><w:pPr><w:sectPr><w:pgSz w:w=\"12240\" w:h=\"15840\"/><w:pgMar w:top=\"1440\" w:right=\"1800\" w:bottom=\"1440\" w:left=\"1800\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/><w:cols w:space=\"720\"/><w:docGrid w:line-pitch=\"360\"/></w:sectPr></w:pPr></w:p><w:subDoc w:link=\"fileName\"/></wx:sect><wx:sect><wx:sub-section><w:p><w:pPr><w:pStyle w:val=\"Heading1\"/></w:pPr></w:p><w:sectPr><w:type w:val=\"continuous\"/><w:pgSz w:w=\"12240\" w:h=\"15840\"/><w:pgMar w:top=\"1440\" w:right=\"1800\" w:bottom=\"1440\" w:left=\"1800\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/><w:cols w:space=\"720\"/><w:docGrid w:line-pitch=\"360\"/></w:sectPr></wx:sub-section></wx:sect>";
    private static final String HYPER_LINK_DOC = "<w:p><w:hlink w:dest=\"fileName\"><w:r wsp:rsidRPr=\"00CE6681\"><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>fileName</w:t></w:r></w:hlink></w:p>";
    private final Appendable strB;
    private final int[] outlineNumber;
    private int outlineLevel;
    private int maxOutlineLevel = 9;
    private int flattenedLevelCount;
    private final Map<String, Integer> alphabetMap;
    private static final String DEFAULT_FONT = "Times New Roman";

    public WordMLProducer(Appendable str) {
        this.strB = str;
        this.outlineNumber = new int[10];
        this.outlineLevel = 0;
        this.flattenedLevelCount = 0;
        this.alphabetMap = new HashMap<String, Integer>();
        this.alphabetMap.put("A.0", 1);
        this.alphabetMap.put("B.0", 2);
        this.alphabetMap.put("C.0", 3);
    }

    public CharSequence startOutlineSubSection() {
        CharSequence paragraphNumber = this.startOutlineSubSection(DEFAULT_FONT, null, null);
        return paragraphNumber;
    }

    public CharSequence startOutlineSubSection(CharSequence font, CharSequence headingText, String outlineType) {
        if (this.okToStartSubsection()) {
            this.outlineNumber[++this.outlineLevel] = this.outlineNumber[this.outlineLevel] + 1;
            CharSequence paragraphNumber = this.getOutlineNumber();
            this.startOutlineSubSection(String.valueOf(outlineType != null ? outlineType : "Heading") + this.outlineLevel, paragraphNumber, font, headingText);
            return paragraphNumber;
        }
        ++this.flattenedLevelCount;
        this.endOutlineSubSection(true);
        OseeLog.log(this.getClass(), (Level)Level.WARNING, (String)("Outline level flattened, max outline level is currently set to " + this.maxOutlineLevel + ", ms word only goes 9 levels deep"));
        return this.startOutlineSubSection(font, headingText, outlineType);
    }

    protected void append(CharSequence value) {
        try {
            this.strB.append(value);
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public void startOutlineSubSection(CharSequence style, CharSequence outlineNumber, CharSequence font, CharSequence headingText) {
        this.append("<wx:sub-section>");
        if (Strings.isValid((CharSequence[])new CharSequence[]{headingText})) {
            this.startParagraph();
            this.append("<w:pPr>");
            this.writeParagraphStyle(style);
            this.append("<w:listPr><wx:t wx:val=\"");
            this.append(outlineNumber);
            this.append("\" wx:wTabBefore=\"540\" wx:wTabAfter=\"90\"/><wx:font wx:val=\"");
            this.append(font);
            this.append("\"/></w:listPr></w:pPr>");
            this.writeHeadingText(headingText);
            this.endParagraph();
        }
    }

    public void startAppendixSubSection(CharSequence style, CharSequence headingText) {
        this.append("<wx:sub-section>");
        if (Strings.isValid((CharSequence[])new CharSequence[]{headingText})) {
            this.startParagraph();
            this.append("<w:pPr>");
            this.writeParagraphStyle(style);
            this.append("</w:pPr>");
            this.writeHeadingText(headingText);
            this.endParagraph();
        }
    }

    public void endAppendixSubSection() {
        this.append("</wx:sub-section>");
    }

    public void setPageBreak(boolean chapterNumbering, int chapterStyle, boolean restartNumbering, String pageLayout) {
        boolean landscape = pageLayout != null && pageLayout.equals("Landscape");
        this.append("<w:p>");
        this.append("<w:pPr>");
        this.append("<w:sectPr>");
        if (landscape) {
            this.append("<w:pgSz w:w=\"15840\" w:h=\"12240\" w:orient=\"landscape\" w:code=\"1\" />");
        } else {
            this.append("<w:pgSz w:w=\"12240\" w:h=\"15840\" w:code=\"1\" />");
        }
        this.append("<w:pgMar w:top=\"1440\" w:right=\"1296\" w:bottom=\"1440\" w:left=\"1296\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/>");
        if (chapterNumbering) {
            this.append("<w:pgNumType ");
            if (restartNumbering) {
                this.append("w:start=\"1\" ");
            }
            this.append(String.format("w:chap-style=\"%s\"/>", chapterStyle));
        }
        this.append("</w:sectPr>");
        this.append("</w:pPr>");
        this.append("</w:p>");
    }

    public void setPageBreak(boolean chapterNumbering, int chapterStyle, boolean restartNumbering) {
        this.setPageBreak(chapterNumbering, chapterStyle, restartNumbering, null);
    }

    private void writeParagraphStyle(CharSequence style) {
        this.append("<w:pStyle w:val=\"");
        this.append(style);
        this.append("\"/>");
    }

    private void writeHeadingText(CharSequence headingText) {
        this.append("<w:r><w:t>");
        this.append(Xml.escape((CharSequence)headingText));
        this.append("</w:t></w:r>");
    }

    public String setHeadingNumbers(String outlineNumber, String template, String outlineType) {
        boolean appendixOutlineType;
        boolean bl = appendixOutlineType = outlineType != null && outlineType.equalsIgnoreCase("APPENDIX");
        if (outlineNumber == null) {
            return template;
        }
        if (appendixOutlineType) {
            char[] chars = outlineNumber.toCharArray();
            template = this.setAppendixStartLetter(chars[0], template);
        } else {
            String[] numbers;
            int index = 1;
            String[] stringArray = numbers = outlineNumber.split("\\.");
            int n = numbers.length;
            int n2 = 0;
            while (n2 < n) {
                String number = stringArray[n2];
                Matcher matcher = Pattern.compile(String.format("<w:start w:val=\"(\\d*?)\"/><w:pStyle w:val=\"Heading%d\"/>", index)).matcher("");
                matcher.reset(template);
                template = matcher.replaceAll(String.format("<w:start w:val=\"%s\"/><w:pStyle w:val=\"Heading%d\"/>", number, index));
                ++index;
                ++n2;
            }
        }
        if (!appendixOutlineType) {
            this.setNextParagraphNumberTo(outlineNumber);
        }
        return template;
    }

    public String setAppendixStartLetter(char chr, String template) {
        template = template.replace("<w:start w:val=\"1\"/><w:nfc w:val=\"3\"/><w:pStyle w:val=\"APPENDIX1\"/>", "<w:start w:val=\"" + (Character.toLowerCase(chr) - 97 + 1) + "\"/><w:nfc w:val=\"3\"/><w:pStyle w:val=\"APPENDIX1\"/>");
        return template;
    }

    public void endOutlineSubSection() {
        this.endOutlineSubSection(false);
    }

    private void endOutlineSubSection(boolean force) {
        if (!force && this.flattenedLevelCount > 0) {
            --this.flattenedLevelCount;
        } else {
            this.append("</wx:sub-section>");
            if (this.outlineLevel + 1 < this.outlineNumber.length) {
                this.outlineNumber[this.outlineLevel + 1] = 0;
            }
            --this.outlineLevel;
        }
    }

    public void addWordMl(CharSequence wordMl) {
        this.append(wordMl);
    }

    public void startParagraph() {
        this.append("<w:p>");
    }

    public void startSubSection() {
        this.append("<wx:sect>");
    }

    public void endSubSection() {
        this.append("</wx:sect>");
    }

    public void createSubDoc(String fileName) {
        if (Strings.isValid((String)fileName)) {
            throw new IllegalArgumentException("The file name can not be null or empty.");
        }
        this.append(SUB_DOC.replace(FILE_NAME, fileName));
    }

    public void createHyperLinkDoc(String fileName) {
        if (!Strings.isValid((String)fileName)) {
            throw new IllegalArgumentException("The file name can not be null or empty.");
        }
        this.append(HYPER_LINK_DOC.replace(FILE_NAME, fileName));
    }

    public void resetListValue() {
        this.startParagraph();
        this.addWordMl(LISTNUM_FIELD_HEAD);
        this.endParagraph();
        this.startParagraph();
        this.addWordMl(LISTNUM_FIELD);
        this.endParagraph();
    }

    public void endParagraph() {
        this.append("</w:p>");
    }

    public void startTable() {
        this.append("<wx:sub-section><w:tbl>");
    }

    public void endTable() {
        this.append("</w:tbl></wx:sub-section>");
    }

    public void startTableRow() {
        this.append("<w:tr>");
    }

    public void endTableRow() {
        this.append("</w:tr>");
    }

    public void startTableColumn() {
        this.append("<w:tc>");
    }

    public void endTableColumn() {
        this.append("</w:tc>");
    }

    public void addTableCaption(String captionText) {
        this.append("<w:p wsp:rsidR=\"003571A9\" wsp:rsidRDefault=\"00AE7B3F\" wsp:rsidP=\"00AE7B3F\"><w:pPr><w:pStyle w:val=\"Caption\"/></w:pPr>");
        this.append("<w:r><w:t>Table </w:t></w:r>");
        this.append("<w:fldSimple w:instr=\" SEQ Table \\* ARABIC \"><w:r><w:rPr><w:noProof/></w:rPr><w:t>");
        this.append("#");
        this.append("</w:t></w:r></w:fldSimple><w:r><w:t>: ");
        this.append(captionText);
        this.append("</w:t></w:r></w:p>");
    }

    public void addTableColumnHeader(String text) {
        this.startTableColumn();
        this.addParagraphBold(text);
        this.endTableColumn();
    }

    public void addTableColumns(String ... datas) {
        String[] stringArray = datas;
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            this.startTableColumn();
            this.addParagraph(data);
            this.endTableColumn();
            ++n2;
        }
    }

    public void addTableRow(String ... datas) {
        this.startTableRow();
        this.addTableColumns(datas);
        this.endTableRow();
    }

    public void addParagraphNoEscape(CharSequence text) {
        this.append("<w:p><w:r><w:t>");
        this.append(text);
        this.append("</w:t></w:r></w:p>");
    }

    public void addEditParagraphNoEscape(CharSequence text) {
        this.startParagraph();
        this.append(text);
        this.endParagraph();
    }

    public void addParagraph(CharSequence text) {
        this.startParagraph();
        this.addTextInsideParagraph(text);
        this.endParagraph();
    }

    public void addParagraphBold(CharSequence text) {
        this.append("<w:p><w:r><w:rPr><w:b/></w:rPr><w:t>");
        this.append(Xml.escape((CharSequence)text));
        this.append("</w:t><w:rPr><w:b/></w:rPr></w:r></w:p>");
    }

    public void addTextInsideParagraph(CharSequence text) {
        this.append("<w:r><w:t>");
        this.append(Xml.escape((CharSequence)text));
        this.append("</w:t></w:r>");
    }

    public void addTextInsideParagraph(CharSequence text, String rgbHexColor) {
        if (rgbHexColor == null) {
            throw new IllegalArgumentException("rgbHexColor can not be null");
        }
        if (rgbHexColor.length() != 6) {
            throw new IllegalArgumentException("rgbHexColor should be a hex string 6 characters long");
        }
        this.append("<w:r><w:rPr><w:color w:val=\"");
        this.append(rgbHexColor);
        this.append("\"/></w:rPr>");
        this.append("<w:t>");
        this.append(Xml.escape((CharSequence)text));
        this.append("</w:t></w:r>");
    }

    public void addOleData(CharSequence oleData) {
        this.append("<w:docOleData>");
        this.append(oleData);
        this.append("</w:docOleData>");
    }

    private CharSequence getOutlineNumber() {
        StringBuilder strB = new StringBuilder();
        int i = 1;
        while (i < this.outlineLevel) {
            strB.append(String.valueOf(this.outlineNumber[i]));
            strB.append(".");
            ++i;
        }
        strB.append(String.valueOf(this.outlineNumber[this.outlineLevel]));
        return strB;
    }

    public boolean okToStartSubsection() {
        return this.outlineLevel < this.maxOutlineLevel;
    }

    public void setNextParagraphNumberTo(String nextOutlineNumber) {
        String[] nextOutlineNumbers = nextOutlineNumber.split("\\.");
        Arrays.fill(this.outlineNumber, 0);
        try {
            int i = 0;
            while (i < nextOutlineNumbers.length) {
                this.outlineNumber[i + 1] = Integer.parseInt(nextOutlineNumbers[i]);
                ++i;
            }
            int n = nextOutlineNumbers.length;
            this.outlineNumber[n] = this.outlineNumber[n] - 1;
            this.outlineLevel = nextOutlineNumbers.length - 1;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setPageLayout(String pageType) {
        boolean landscape;
        boolean bl = landscape = pageType != null && pageType.equals("Landscape");
        if (landscape) {
            this.append("<w:p>");
            this.append("<w:pPr>");
            this.append("<w:sectPr>");
            this.append("<w:pgSz w:w=\"15840\" w:h=\"12240\" w:orient=\"landscape\" w:code=\"1\" />");
            this.append("</w:sectPr>");
            this.append("</w:pPr>");
            this.append("</w:p>");
        }
    }

    public void setMaxOutlineLevel(int maxOutlineLevel) {
        this.maxOutlineLevel = maxOutlineLevel;
    }

    public void startErrorLog() {
        this.startAppendixSubSection("Heading1", "Error Log");
        this.startTable();
        this.addWordMl("<w:tblPr><w:tblW w:w=\"0\" w:type=\"auto\"/><w:tblBorders><w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/></w:tblBorders></w:tblPr>");
        this.startTableRow();
        this.addTableColumnHeader("Artifact Id");
        this.addTableColumnHeader("Artifact Name");
        this.addTableColumnHeader("Artifact Type");
        this.addTableColumnHeader("Description");
        this.endTableRow();
    }

    public void addErrorRow(String id, String name, String type, String description) {
        this.startTableRow();
        this.addTableColumns(id, name, type, description);
        this.endTableRow();
    }

    public void endErrorLog() {
        this.endTable();
        this.addTableCaption("Error Log");
        this.endAppendixSubSection();
        this.setPageBreak(true, 1, true);
    }
}

