/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.StringDataSource;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public abstract class OseeEmail
extends MimeMessage {
    protected static final String emailType = "mail.smtp.host";
    protected static final String HTMLHead = "<html><body>\n";
    protected static final String HTMLEnd = "</body></html>\n";
    public static final String plainText = "text/plain";
    public static final String HTMLText = "text/html";
    protected static String defaultMailServer;
    private String body;
    private String bodyType;
    private final Multipart mainMessage;

    public OseeEmail() {
        super(OseeEmail.getSession());
        this.body = null;
        this.bodyType = null;
        this.mainMessage = new MimeMultipart();
    }

    public OseeEmail(Collection<String> toAddresses, String fromAddress, String replyToAddress, String subject, String body, BodyType bodyType) {
        block4: {
            this();
            try {
                this.setRecipients(toAddresses.toArray(new String[toAddresses.size()]));
                this.setFrom(fromAddress);
                this.setSubject(subject);
                this.setReplyTo(replyToAddress);
                if (bodyType == BodyType.Text) {
                    this.setBody(body);
                    break block4;
                }
                if (bodyType == BodyType.Html) {
                    this.setHTMLBody(body);
                    break block4;
                }
                throw new IllegalArgumentException("Unhandled body type " + (Object)((Object)bodyType));
            }
            catch (MessagingException ex) {
                OseeLog.log(OseeEmail.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    public OseeEmail(String fromEmail, String toAddress, String subject, String body, BodyType bodyType) {
        this(Arrays.asList(toAddress), fromEmail, fromEmail, subject, body, bodyType);
    }

    public void addRecipients(String addresses) throws MessagingException {
        this.addRecipients(Message.RecipientType.TO, addresses);
    }

    public void addRecipients(String[] addresses) throws MessagingException {
        this.addRecipients(Message.RecipientType.TO, addresses);
    }

    public void addRecipients(Message.RecipientType type, String[] addresses) throws MessagingException {
        if (addresses != null) {
            InternetAddress[] newAddresses = new InternetAddress[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                newAddresses[i] = new InternetAddress(addresses[i]);
                ++i;
            }
            this.addRecipients(type, (Address[])newAddresses);
        }
    }

    public void setRecipients(String addresses) throws MessagingException {
        this.setRecipients(Message.RecipientType.TO, addresses);
    }

    public void setRecipients(String[] addresses) throws MessagingException {
        this.setRecipients(Message.RecipientType.TO, addresses);
    }

    public void setRecipients(Message.RecipientType type, String[] addresses) throws MessagingException {
        if (addresses != null) {
            InternetAddress[] newAddresses = new InternetAddress[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                newAddresses[i] = new InternetAddress(addresses[i]);
                ++i;
            }
            this.setRecipients(type, (Address[])newAddresses);
        }
    }

    public void setFrom(String address) throws AddressException, MessagingException {
        this.setFrom((Address)new InternetAddress(address));
    }

    public void setReplyTo(String address) throws MessagingException {
        InternetAddress[] replyAddresses = new InternetAddress[]{new InternetAddress(address)};
        this.setReplyTo((Address[])replyAddresses);
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBody(String text) {
        this.body = text;
        this.bodyType = plainText;
    }

    public void addBody(String text) {
        if (this.bodyType == null) {
            this.setBody(text);
        } else if (this.bodyType.equals(plainText)) {
            this.body = String.valueOf(this.body) + text;
        }
    }

    public void setHTMLBody(String htmlText) {
        this.bodyType = HTMLText;
        this.body = HTMLHead + htmlText;
    }

    public void addHTMLBody(String htmlText) {
        if (this.bodyType == null) {
            this.setHTMLBody(htmlText);
        } else if (this.bodyType.equals(HTMLText)) {
            this.body = String.valueOf(this.body) + htmlText;
        }
    }

    public void setSubject(String subject) {
        try {
            super.setSubject(subject);
        }
        catch (MessagingException messagingException) {}
    }

    public void send() {
        if (Strings.isValid((String)defaultMailServer)) {
            new SendThread(this).start();
        }
    }

    public XResultData sendLocalThread() {
        XResultData results = new XResultData();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
                mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
                mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
                mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
                mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
                mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
                CommandMap.setDefaultCommandMap((CommandMap)mc);
                this.setClassLoader();
                if (this.bodyType == null) {
                    this.bodyType = plainText;
                    this.body = "";
                } else if (this.bodyType.equals(HTMLText)) {
                    this.body = String.valueOf(this.body) + HTMLEnd;
                }
                messageBodyPart.setContent((Object)this.body, this.bodyType);
                this.mainMessage.addBodyPart((BodyPart)messageBodyPart, 0);
                this.setContent(this.mainMessage);
                Transport.send((Message)this);
            }
            catch (Exception ex) {
                results.errorf("Exception sending message (contents below) [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
                if (!results.toString().contains("User unknown")) {
                    results.logf("Contents are [%s]", new Object[]{this.body});
                    OseeLog.log(OseeEmail.class, (Level)Level.SEVERE, (String)results.toString());
                }
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
        return results;
    }

    public abstract void setClassLoader();

    private static Session getSession() {
        Properties props = System.getProperties();
        props.put(emailType, defaultMailServer);
        return Session.getDefaultInstance((Properties)props, null);
    }

    public void addAttachment(DataSource source, String attachmentName) throws MessagingException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setDataHandler(new DataHandler(source));
        messageBodyPart.setFileName(attachmentName);
        this.mainMessage.addBodyPart((BodyPart)messageBodyPart);
    }

    public void addAttachment(File file) throws MessagingException {
        this.addAttachment((DataSource)new FileDataSource(file), file.getName());
    }

    public void addAttachment(String contents, String attachmentName) throws MessagingException {
        this.addAttachment((DataSource)new StringDataSource(contents, attachmentName), attachmentName);
    }

    public static String getDefaultMailServer() {
        return defaultMailServer;
    }

    public static void setDefaultMailServer(String defaultMailServer) {
        OseeEmail.defaultMailServer = defaultMailServer;
    }

    public static enum BodyType {
        Html,
        Text;

    }

    private class SendThread
    extends Thread {
        private final OseeEmail email;

        public SendThread(OseeEmail email) {
            this.email = email;
        }

        @Override
        public void run() {
            XResultData results = this.email.sendLocalThread();
            if (results.isFailed()) {
                OseeLog.log(OseeEmail.class, (Level)Level.SEVERE, (String)results.toString());
            }
        }
    }
}

