/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public interface RelationTypeToken
extends NamedId {
    public static final RelationTypeToken SENTINEL = RelationTypeToken.create(Id.SENTINEL, "Sentinel", null, null, null, null, null, null);

    public static @NonNull RelationTypeToken create(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName) {
        return RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, ArtifactTypeToken.SENTINEL, false);
    }

    public static @NonNull RelationTypeToken create(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName, ArtifactTypeToken relationArtifactType, boolean newRelationTable) {
        final class RelationTypeTokenImpl
        extends NamedIdBase
        implements RelationTypeToken {
            private final RelationTypeMultiplicity relationTypeMultiplicity;
            private final RelationSorter order;
            private final ArtifactTypeToken artifactTypeA;
            private final ArtifactTypeToken artifactTypeB;
            private final String sideAName;
            private final String sideBName;
            private final ArtifactTypeToken relationArtifactType;
            private final boolean newRelationTable;

            public RelationTypeTokenImpl(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName, ArtifactTypeToken relationArtifactType, boolean newRelationTable) {
                super(Long.valueOf(id), name);
                this.relationTypeMultiplicity = relationTypeMultiplicity;
                this.order = order;
                this.artifactTypeA = artifactTypeA;
                this.artifactTypeB = artifactTypeB;
                this.sideAName = sideAName;
                this.sideBName = sideBName;
                this.relationArtifactType = relationArtifactType;
                this.newRelationTable = newRelationTable;
            }

            @Override
            public RelationTypeMultiplicity getMultiplicity() {
                return this.relationTypeMultiplicity;
            }

            @Override
            public RelationSorter getOrder() {
                return this.order;
            }

            @Override
            public ArtifactTypeToken getArtifactType(RelationSide relationSide) {
                ArtifactTypeToken artifactType = null;
                if (relationSide.equals((Object)RelationSide.SIDE_A)) {
                    artifactType = this.artifactTypeA;
                } else if (relationSide.equals((Object)RelationSide.SIDE_B)) {
                    artifactType = this.artifactTypeB;
                }
                return artifactType;
            }

            @Override
            public String getSideName(RelationSide relationSide) {
                return relationSide.equals((Object)RelationSide.SIDE_A) ? this.sideAName : this.sideBName;
            }

            @Override
            public boolean isArtifactTypeAllowed(RelationSide relationSide, ArtifactTypeToken artifactType) {
                return artifactType.inheritsFrom(this.getArtifactType(relationSide));
            }

            @Override
            public boolean isOrdered() {
                return !RelationSorter.UNORDERED.equals((Object)this.order);
            }

            @Override
            public ArtifactTypeToken getRelationArtifactType() {
                return this.relationArtifactType;
            }

            @Override
            public boolean isNewRelationTable() {
                return this.newRelationTable;
            }
        }
        return new RelationTypeTokenImpl(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, relationArtifactType, newRelationTable);
    }

    public RelationTypeMultiplicity getMultiplicity();

    public RelationSorter getOrder();

    public ArtifactTypeToken getArtifactType(RelationSide var1);

    public String getSideName(RelationSide var1);

    public boolean isArtifactTypeAllowed(RelationSide var1, ArtifactTypeToken var2);

    public boolean isOrdered();

    public boolean isNewRelationTable();

    public ArtifactTypeToken getRelationArtifactType();

    default public int getRelationSideMax(ArtifactTypeToken artifactType, RelationSide relationSide) {
        return this.isArtifactTypeAllowed(relationSide, artifactType) ? this.getMultiplicity().getLimit(relationSide) : 0;
    }
}

