/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox;

import com.lowagie.text.Document;
import com.lowagie.toolbox.AbstractTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Versions
extends JFrame {
    private static final long serialVersionUID = 2925242862240301106L;
    JLabel library_versions = new JLabel();
    JTable plugin_versions = new JTable();
    JScrollPane scroll_versions = new JScrollPane();

    public Versions() {
        super("Plugins and their version");
        try {
            this.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initialize() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.scroll_versions.setViewportView(this.plugin_versions);
        this.library_versions.setIcon(new ImageIcon(Versions.class.getResource("1t3xt.gif")));
        this.getContentPane().add((Component)this.library_versions, "North");
        this.getContentPane().add((Component)this.scroll_versions, "Center");
        Properties properties = System.getProperties();
        Runtime runtime = Runtime.getRuntime();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<p>iTexttoolbox version: " + Versions.class.getPackage().getImplementationVersion() + "</p>");
        stringBuffer.append("<p>iText version: " + Document.getVersion() + "</p>");
        stringBuffer.append("<p>java.version: " + properties.getProperty("java.version") + "</p>");
        stringBuffer.append("<p>java.vendor: " + properties.getProperty("java.vendor") + "</p>");
        stringBuffer.append("<p>java.home: " + properties.getProperty("java.home") + "</p>");
        stringBuffer.append("<p>java.freeMemory: " + runtime.freeMemory() + " bytes" + "</p>");
        stringBuffer.append("<p>java.totalMemory: " + runtime.totalMemory() + " bytes" + "</p>");
        stringBuffer.append("<p>user.home: " + properties.getProperty("user.home") + "</p>");
        stringBuffer.append("<p>os.name: " + properties.getProperty("os.name") + "</p>");
        stringBuffer.append("<p>os.arch: " + properties.getProperty("os.arch") + "</p>");
        stringBuffer.append("<p>os.version: " + properties.getProperty("os.version") + "</p>");
        stringBuffer.append("</html>");
        this.library_versions.setText(stringBuffer.toString());
        TableModel tableModel = this.getVersionTableModel(AbstractTool.versionsarray);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(tableModel);
        this.plugin_versions.setRowSorter(tableRowSorter);
        this.plugin_versions.setModel(tableModel);
        this.pack();
    }

    public TableModel getVersionTableModel(final ArrayList<String> arrayList) {
        return new AbstractTableModel(){
            private static final long serialVersionUID = 5105003782164682777L;

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public int getRowCount() {
                return arrayList.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        String string = (String)arrayList.get(n);
                        return string.split(".java")[0];
                    }
                    case 1: {
                        String string = (String)arrayList.get(n);
                        return string.split(" ")[1];
                    }
                    case 2: {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String string = (String)arrayList.get(n);
                        try {
                            return simpleDateFormat.parse(string.split(" ")[2] + " " + string.split(" ")[3]);
                        }
                        catch (ParseException parseException) {
                            return null;
                        }
                    }
                    case 3: {
                        String string = (String)arrayList.get(n);
                        return string.split(" ")[4];
                    }
                }
                return arrayList;
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Version";
                    }
                    case 2: {
                        return "Changed";
                    }
                    case 3: {
                        return "ChangeBy";
                    }
                }
                return "";
            }

            public Class<? extends Object> getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Date.class;
                    }
                    case 3: {
                        return String.class;
                    }
                }
                return null;
            }
        };
    }

    public static void main(String[] stringArray) {
        Versions versions = new Versions();
        versions.setDefaultCloseOperation(3);
        versions.setVisible(true);
    }
}

