/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.branch.graph.model.Node;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;

public class BranchModel
extends Node {
    private static final long serialVersionUID = 1017422142119868019L;
    private BranchModel parent;
    private final LinkedList<TxModel> txs;
    private final List<BranchModel> children;
    private transient BranchId branch;
    private transient boolean isLoaded;
    private transient int depth;
    private transient boolean txsVisible;

    public BranchModel(BranchId branch) {
        this.branch = branch;
        this.children = new ArrayList<BranchModel>();
        this.txs = new LinkedList();
        this.parent = null;
        this.isLoaded = false;
        this.depth = -1;
        this.txsVisible = true;
    }

    protected void reset() {
        this.children.clear();
        this.parent = null;
    }

    protected void resetTxs() {
        this.txs.clear();
    }

    protected boolean isLoaded() {
        return this.isLoaded;
    }

    protected void setIsLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public boolean isDefaultBranch() {
        return false;
    }

    public BranchModel getParentBranch() {
        return this.parent;
    }

    protected void setParentBranch(BranchModel parent) {
        this.parent = parent;
    }

    public List<BranchModel> getChildren() {
        return this.children;
    }

    public List<BranchModel> getAllChildrenBelow() {
        ArrayList<BranchModel> children = new ArrayList<BranchModel>(this.getChildren());
        for (BranchModel child : this.getChildren()) {
            children.addAll(child.getAllChildrenBelow());
        }
        return children;
    }

    protected void addChildBranchModel(BranchModel branchModel) {
        if (!this.children.contains(branchModel)) {
            branchModel.setParentBranch(this);
            int toSearch = branchModel.getAllChildrenBelow().size();
            int insertAt = -1;
            for (BranchModel child : this.children) {
                if (child.getAllChildrenBelow().size() > toSearch) break;
                ++insertAt;
            }
            int size = this.children.size();
            if (size != 0 && insertAt >= 0 && insertAt < size) {
                this.children.add(insertAt, branchModel);
            } else {
                this.children.add(branchModel);
            }
        }
    }

    protected void addTx(TxModel txModel) {
        if (!this.txs.contains(txModel)) {
            txModel.setBranchModel(this);
            Long toSearch = txModel.getRevision();
            int insertAt = -1;
            int index = 0;
            while (index < this.txs.size()) {
                TxModel toCheck = this.txs.get(index);
                if (toCheck.getRevision() > toSearch) {
                    insertAt = index;
                    break;
                }
                ++index;
            }
            if (insertAt > -1) {
                TxModel greater = this.txs.get(insertAt);
                TxModel parent = greater.getParentTx();
                if (parent != null) {
                    txModel.setParentTx(parent);
                } else {
                    int toGet = insertAt - 1;
                    if (toGet >= 0) {
                        txModel.setParentTx(this.txs.get(toGet));
                    }
                }
                greater.setParentTx(txModel);
                this.txs.add(insertAt, txModel);
            } else {
                TxModel last = this.getLastTx();
                if (last != null) {
                    txModel.setParentTx(last);
                }
                this.txs.add(txModel);
            }
        }
    }

    public List<TxModel> getTxs() {
        return this.txs;
    }

    public TxModel getFirstTx() {
        return this.txs.isEmpty() ? null : this.txs.get(0);
    }

    public TxModel getLastTx() {
        return this.txs.isEmpty() ? null : this.txs.get(this.txs.size() - 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BranchModel) {
            BranchModel other = (BranchModel)obj;
            return other.getBranch().equals(this.getBranch());
        }
        return false;
    }

    public int hashCode() {
        return this.branch.hashCode();
    }

    public String toString() {
        return String.format("Branch:[%s] Type:[%s] Children:[%s] TxNodes:[%s]", this.branch.getId(), BranchManager.getType((BranchId)this.branch).getName(), this.children.size(), this.txs.size());
    }

    public boolean areTxsVisible() {
        return this.txsVisible;
    }

    public void setTxsVisible(boolean txsVisible) {
        if (this.areTxsVisible() != txsVisible) {
            this.txsVisible = txsVisible;
            for (TxModel tx : this.txs) {
                tx.setVisible(txsVisible);
            }
        }
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }
}

