/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.MergeBranch;
import org.eclipse.osee.framework.core.model.cache.AbstractOseeLoadingCache;
import org.eclipse.osee.framework.core.model.cache.IOseeDataAccessor;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class BranchCache
extends AbstractOseeLoadingCache<Branch> {
    private final CompositeKeyHashMap<BranchId, ArtifactId, Branch> branchViews = new CompositeKeyHashMap(50, false);

    public BranchCache(IOseeDataAccessor<Branch> dataAccessor) {
        super(dataAccessor);
    }

    public MergeBranch findMergeBranch(BranchId sourceBranch, BranchId destinationBranch) {
        Conditions.checkNotNull((Object)sourceBranch, (String)"source branch");
        Conditions.checkNotNull((Object)destinationBranch, (String)"destination branch");
        MergeBranch toReturn = null;
        for (Branch branch : this.getAll()) {
            MergeBranch mergeBranch;
            if (!(branch instanceof MergeBranch) || !sourceBranch.equals((mergeBranch = (MergeBranch)branch).getSourceBranch()) || !destinationBranch.equals(mergeBranch.getDestinationBranch())) continue;
            toReturn = mergeBranch;
            break;
        }
        return toReturn;
    }

    public MergeBranch findFirstMergeBranch(BranchId sourceBranch) {
        Conditions.checkNotNull((Object)sourceBranch, (String)"source branch");
        for (Branch branch : this.getAll()) {
            MergeBranch mergeBranch;
            if (!(branch instanceof MergeBranch) || !sourceBranch.equals((mergeBranch = (MergeBranch)branch).getSourceBranch())) continue;
            return mergeBranch;
        }
        throw new OseeNotFoundException("Merge branch not found for source [%s]", new Object[]{sourceBranch});
    }

    public List<MergeBranch> findAllMergeBranches(BranchId sourceBranch) {
        Conditions.checkNotNull((Object)sourceBranch, (String)"source branch");
        ArrayList<MergeBranch> toReturn = new ArrayList<MergeBranch>();
        for (Branch branch : this.getAll()) {
            MergeBranch mergeBranch;
            if (!(branch instanceof MergeBranch) || !sourceBranch.equals((mergeBranch = (MergeBranch)branch).getSourceBranch())) continue;
            toReturn.add(mergeBranch);
        }
        return toReturn;
    }

    public Branch getBranchWithView(BranchId branchId, ArtifactId viewId) {
        return (Branch)((Object)this.branchViews.get((Object)branchId, (Object)viewId));
    }

    public Branch cacheBranchWithView(Branch branch, ArtifactToken view) {
        Branch branchView = Branch.createBranchView(branch, (ArtifactId)view, String.valueOf(branch.getName()) + " [view: " + view.getName() + "]");
        this.branchViews.put((Object)branchView, (Object)view, (Object)branchView);
        return branchView;
    }

    public synchronized List<BranchToken> getBranches(Predicate<Branch> branchFilter) {
        return this.getRawValues().stream().filter(branchFilter).collect(Collectors.toList());
    }

    public Branch get(BranchId branch) {
        return (Branch)((Object)this.getById(branch.getId()));
    }
}

