/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public final class FontManager {
    public static Map<String, Font> fontMap = new HashMap<String, Font>();

    private FontManager() {
    }

    public static Font getDefaultLabelFont() {
        return FontManager.getFont("arial", 12, 1);
    }

    public static Font getCourierNew8() {
        return FontManager.getFont("Courier New", 8, 0);
    }

    public static Font getCourierNew12Bold() {
        return FontManager.getFont("Courier New", 12, 1);
    }

    public static Font getCourierNew12() {
        return FontManager.getFont("Courier New", 12, 0);
    }

    public static Font getFont(String fontName, int size, int swtType) {
        String hashKey = String.valueOf(fontName) + "-" + size + "-" + swtType;
        if (!fontMap.containsKey(hashKey)) {
            Font baseFont = JFaceResources.getDefaultFont();
            FontData[] fontDatas = baseFont.getFontData();
            FontData fontData = fontDatas.length > 0 ? fontDatas[0] : new FontData(fontName, size, swtType);
            fontMap.put(hashKey, new Font(baseFont.getDevice(), fontData.getName(), fontData.getHeight(), 1));
        }
        return fontMap.get(hashKey);
    }
}

