/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;

public class CriteriaPagination
extends Criteria {
    private final long pageNum;
    private final long pageSize;

    public CriteriaPagination(long pageNum, long pageSize) {
        this.pageSize = pageSize;
        this.pageNum = pageNum;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public long getPageNum() {
        return this.pageNum;
    }

    @Override
    public void checkValid(Options options) {
        Conditions.checkNotNull((Object)this.pageNum, (String)"pageNum");
        Conditions.checkNotNull((Object)this.pageSize, (String)"pageSize");
        Conditions.assertNotEquals((int)((int)this.pageNum), (int)0, (String)"PageNum is equal to 0");
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.pageNum + " " + this.pageSize;
    }
}

