/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.old;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentListMap<MAP_TYPE, LIST_TYPE> {
    private final Map<MAP_TYPE, List<LIST_TYPE>> data;
    private final List<LIST_TYPE> EMPTY_LIST = new ArrayList<LIST_TYPE>();

    public ConcurrentListMap() {
        this.data = new HashMap<MAP_TYPE, List<LIST_TYPE>>();
    }

    public synchronized boolean add(MAP_TYPE key, LIST_TYPE value) {
        List<LIST_TYPE> values = this.data.get(key);
        if (values == null) {
            values = new CopyOnWriteArrayList<LIST_TYPE>();
            this.data.put(key, values);
        }
        if (values.contains(value)) {
            return false;
        }
        values.add(value);
        return true;
    }

    public synchronized List<LIST_TYPE> get(MAP_TYPE key) {
        List<LIST_TYPE> values = this.data.get(key);
        if (values == null) {
            return this.EMPTY_LIST;
        }
        return values;
    }

    public synchronized boolean remove(MAP_TYPE key, LIST_TYPE value) {
        List<LIST_TYPE> values = this.data.get(key);
        if (values == null) {
            return false;
        }
        return values.remove(value);
    }

    public void clear() {
        this.data.clear();
    }
}

