/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookWriter;

public class ExcelWorkbookReader {
    private Workbook workbook;
    private Sheet activeSheet;

    public ExcelWorkbookReader(InputStream inputStream, ExcelWorkbookWriter.WorkbookFormat format) {
        try {
            this.workbook = format.equals((Object)ExcelWorkbookWriter.WorkbookFormat.XLS) ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public void closeWorkbook() {
        try {
            this.workbook.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public void setActiveSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new OseeArgumentException("No sheet found with name " + sheetName, new Object[0]);
        }
        this.activeSheet = sheet;
    }

    public void setActiveSheet(int index) {
        Sheet sheet = this.workbook.getSheetAt(index);
        if (sheet == null) {
            throw new OseeArgumentException("No sheet found at index " + index, new Object[0]);
        }
        this.activeSheet = sheet;
    }

    public Object getCellValue(int rowIndex, int cellIndex) {
        this.checkActiveSheet();
        Row row = this.activeSheet.getRow(rowIndex);
        if (row == null) {
            throw new OseeArgumentException("Row index " + rowIndex + " is invalid for sheet " + this.activeSheet.getSheetName(), new Object[0]);
        }
        Cell cell = row.getCell(cellIndex);
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: 
            case FORMULA: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return cell.getNumericCellValue();
            }
        }
        return null;
    }

    public String getCellStringValue(int rowIndex, int cellIndex) {
        Object val = this.getCellValue(rowIndex, cellIndex);
        return val == null ? "" : val.toString();
    }

    public double getCellNumericValue(int rowIndex, int cellIndex) {
        return Double.parseDouble(this.getCellValue(rowIndex, cellIndex).toString());
    }

    public String getCellFormulaValue(int rowIndex, int cellIndex) {
        this.checkActiveSheet();
        Cell cell = this.getCell(rowIndex, cellIndex);
        return cell.getCellFormula();
    }

    public String getCellHyperlinkString(int rowIndex, int cellIndex) {
        this.checkActiveSheet();
        Cell cell = this.getCell(rowIndex, cellIndex);
        return cell.getHyperlink().getAddress();
    }

    private Cell getCell(int rowIndex, int cellIndex) {
        this.checkActiveSheet();
        Row row = this.activeSheet.getRow(rowIndex);
        if (row == null) {
            throw new OseeArgumentException("Row index " + rowIndex + " is invalid for sheet " + this.activeSheet.getSheetName(), new Object[0]);
        }
        Cell cell = row.getCell(cellIndex);
        if (cell == null) {
            throw new OseeArgumentException("Cell index " + cellIndex + " is invalid for row " + rowIndex + " on sheet " + this.activeSheet.getSheetName(), new Object[0]);
        }
        return cell;
    }

    public boolean rowExists(int rowIndex) {
        this.checkActiveSheet();
        return this.activeSheet.getRow(rowIndex) != null;
    }

    public boolean isCellValid(int rowIndex, int cellIndex) {
        this.checkActiveSheet();
        Row row = this.activeSheet.getRow(rowIndex);
        Cell cell = row.getCell(cellIndex);
        return cell != null;
    }

    public List<String> getMergedRegions() {
        this.checkActiveSheet();
        return this.activeSheet.getMergedRegions().stream().map(r -> r.formatAsString()).collect(Collectors.toList());
    }

    private void checkActiveSheet() {
        if (this.activeSheet == null) {
            throw new OseeArgumentException("No sheet is active. Please create a sheet or set a sheet as active before writing.", new Object[0]);
        }
    }
}

