/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.task.related.IAutoGenTaskData;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditor;
import org.eclipse.osee.ats.ide.workflow.task.related.TaskEditorRelatedTasksProvider;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class ShowAllRelatedTasksAction
extends Action {
    private static final String SHOW_ALL = "Show All Related Tasks";
    private final TaskArtifact task;

    public ShowAllRelatedTasksAction(TaskArtifact task) {
        super(SHOW_ALL);
        this.task = task;
        this.setToolTipText("Show all related tasks from all programs.");
    }

    public void run() {
        String srchStr;
        IAutoGenTaskData data = AtsApiService.get().getTaskRelatedService().getAutoGenTaskData((IAtsTask)this.task);
        String string = srchStr = data.hasRelatedArt() ? data.getRelatedArtName() : this.task.getName();
        if (!Strings.isValid((String)srchStr)) {
            AWorkbench.popup((String)"ERROR", (String)"Unable to extract requirement from task name");
            return;
        }
        Job job = new Job(SHOW_ALL){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        TaskEditor.open(new TaskEditorRelatedTasksProvider(Arrays.asList(srchStr), Arrays.asList(ShowAllRelatedTasksAction.this.task), true, false));
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.TASK);
    }
}

