/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.task.IAtsTaskProvider;
import org.eclipse.osee.ats.api.task.related.AutoGenVersion;
import org.eclipse.osee.ats.api.task.related.DerivedFromTaskData;
import org.eclipse.osee.ats.api.task.related.IAutoGenTaskData;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.core.task.related.AbstractAtsTaskRelatedService;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.KindType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.revision.ChangeData;

public class AtsTaskRelatedService
extends AbstractAtsTaskRelatedService {
    public AtsTaskRelatedService(AtsApi atsApi) {
        super(atsApi);
    }

    public void getRelatedChangedArtifactFromChangeReport(DerivedFromTaskData trd) {
        ChangeData changeData = AtsApiService.get().getBranchServiceIde().getChangeDataFromEarliestTransactionId((TeamWorkFlowArtifact)trd.getDerivedFromTeamWf().getStoreObject());
        this.getTaskRelatedData(trd, changeData);
    }

    private DerivedFromTaskData getTaskRelatedData(DerivedFromTaskData trd, ChangeData changeData) {
        IAutoGenTaskData data = this.atsApi.getTaskRelatedService().getAutoGenTaskData(trd.getTask());
        if (data.isNoChangedArtifact()) {
            trd.getResults().error("No changed artifact to show");
            return trd;
        }
        if (!data.hasRelatedArt()) {
            trd.getResults().error("Task is not against artifact or is named incorrectly.\n\nMust be \"Code|Test \"<partition>\" for \"<requirement name>\"");
            return trd;
        }
        if (!trd.isDeleted()) {
            Artifact headArtifact = AtsTaskRelatedService.findHeadArtifact(changeData, data.getRelatedArtName(), data.getAddDetails());
            if (headArtifact == null) {
                trd.getResults().error("Corresponding requirement can not be found.");
                return trd;
            }
            Artifact latestArt = null;
            if (!headArtifact.isDeleted()) {
                latestArt = ArtifactQuery.getArtifactFromToken((ArtifactId)headArtifact, (DeletionFlag)DeletionFlag.INCLUDE_DELETED);
                trd.setLatestArt((ArtifactToken)latestArt);
            }
        }
        return trd;
    }

    public static Artifact findHeadArtifact(ChangeData changeData, String name, String appendedStr) {
        Artifact headArtifact = null;
        for (Artifact art : changeData.getArtifacts(KindType.ArtifactOrRelation, new ModificationType[]{ModificationType.NEW, ModificationType.MODIFIED})) {
            if (Strings.isValid((String)appendedStr) && appendedStr.equals(" (Impl Details)") && art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails})) {
                if (!name.contains(art.getName())) continue;
                headArtifact = art;
                break;
            }
            if (!Strings.isInValid((String)appendedStr) || art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails}) || !art.getName().contains(name)) continue;
            headArtifact = art;
            break;
        }
        if (headArtifact == null) {
            for (Artifact art : changeData.getArtifacts(KindType.ArtifactOrRelation, new ModificationType[]{ModificationType.DELETED})) {
                if (!appendedStr.equals(" (Deleted)") || !name.contains(art.getName())) continue;
                headArtifact = art;
                break;
            }
        }
        return headArtifact;
    }

    public IAutoGenTaskData getAutoGenTaskData(IAtsTask task) {
        String autoGenVerStr = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.TaskAutoGenVersion, (Object)AutoGenVersion.Other.getName());
        for (IAtsTaskProvider taskProvider : this.atsApi.getTaskService().getTaskProviders()) {
            IAutoGenTaskData taskGenData = taskProvider.getAutoGenTaskData(autoGenVerStr, task);
            if (taskGenData == null) continue;
            return taskGenData;
        }
        return null;
    }
}

