/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.task.AtsTaskEndpointApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskNameProviderToken;
import org.eclipse.osee.ats.api.task.create.IAtsChangeReportTaskNameProvider;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.task.AbstractAtsTaskServiceCore;
import org.eclipse.osee.ats.core.task.ChangeReportTaskNameProviderService;
import org.eclipse.osee.ats.core.workflow.Task;
import org.eclipse.osee.ats.ide.column.RelatedToStateColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.workflow.task.IAtsTaskServiceIde;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryComboComboDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryComboDialog;

public class AtsTaskService
extends AbstractAtsTaskServiceCore
implements IAtsTaskServiceIde {
    private final AtsApi atsApi;

    public AtsTaskService(AtsApiIde atsClient) {
        super((AtsApi)atsClient);
        this.atsApi = atsClient;
    }

    public NewTaskSet createTasks(NewTaskSet newTaskSet) {
        AtsTaskEndpointApi taskEp = this.atsApi.getServerEndpoints().getTaskEp();
        newTaskSet = taskEp.create(newTaskSet);
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        for (NewTaskData newTaskData : newTaskSet.getNewTaskDatas()) {
            Long teamWfId = newTaskData.getTeamWfId();
            Artifact art = ArtifactCache.getActive((ArtifactToken)ArtifactToken.valueOf((long)teamWfId, (BranchId)this.atsApi.getAtsBranch()));
            if (art != null) {
                arts.add(art);
            }
            for (JaxAtsTask task : newTaskData.getTasks()) {
                task.setAtsApi(this.atsApi);
            }
        }
        ArtifactQuery.reloadArtifacts(arts);
        return newTaskSet;
    }

    @Override
    public TaskArtifact createNewTaskWithDialog(IAtsTeamWorkflow teamWf) {
        TaskArtifact taskArt;
        block9: {
            NewTaskSet taskSet;
            block10: {
                List<String> validStates;
                taskArt = null;
                EntryComboDialog ed = null;
                EntryComboComboDialog ed2 = null;
                Collection taskWorkDefs = this.atsApi.getTaskService().calculateTaskWorkDefs(teamWf);
                String comment = "Create New Task";
                if (taskWorkDefs.size() == 0 || taskWorkDefs.size() == 1) {
                    ed = new EntryComboDialog(comment, "Enter Task Title", RelatedToStateColumn.RELATED_TO_STATE_SELECTION);
                    validStates = RelatedToStateColumn.getValidInWorkStates((TeamWorkFlowArtifact)teamWf.getStoreObject());
                    ed.setOptions(validStates);
                } else {
                    ed2 = new EntryComboComboDialog(comment, "Enter Task Title and Select Task Work Definition", RelatedToStateColumn.RELATED_TO_STATE_SELECTION, "Select Task Work Definition");
                    ed = ed2;
                    validStates = RelatedToStateColumn.getValidInWorkStates((TeamWorkFlowArtifact)teamWf.getStoreObject());
                    ed2.setOptions(validStates);
                    ed2.setOptions2(taskWorkDefs);
                    ed2.setCombo2Required(true);
                }
                if (ed.open() != 0) break block9;
                NewTaskSet newTaskSet = NewTaskSet.createWithData((String)comment, (Long)teamWf.getId(), (String)this.atsApi.getUserService().getCurrentUser().getUserId());
                NewTaskData newTaskData = newTaskSet.getTaskData();
                String title = ed.getEntry();
                JaxAtsTask task = JaxAtsTask.create((NewTaskData)newTaskData, (String)title, (AtsUser)this.atsApi.getUserService().getCurrentUser(), (Date)new Date());
                task.setId(ArtifactId.SENTINEL.getId());
                if (ed2 != null) {
                    task.setWorkDef(((WorkDefinition)ed2.getSelection2()).getIdString());
                } else if (taskWorkDefs.size() == 1) {
                    task.setWorkDef(((WorkDefinition)taskWorkDefs.iterator().next()).getIdString());
                }
                if (Strings.isValid((String)ed.getSelection())) {
                    task.setRelatedToState(ed.getSelection());
                }
                taskSet = this.atsApi.getTaskService().createTasks(newTaskSet);
                if (!newTaskSet.isErrors()) break block10;
                XResultDataUI.report((XResultData)newTaskSet.getResults(), (String)title);
                return null;
            }
            try {
                JaxAtsTask jTask = (JaxAtsTask)taskSet.getTaskData().getTasks().iterator().next();
                taskArt = (TaskArtifact)this.atsApi.getQueryService().getArtifact(jTask.getId());
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return taskArt;
    }

    public ChangeReportTaskData createTasks(ChangeReportTaskData changeReportTaskData) {
        ChangeReportTaskData crtd = this.atsApi.getServerEndpoints().getTaskEp().create(changeReportTaskData);
        this.reloadTasksIfNecessary(crtd);
        return crtd;
    }

    private void reloadTasksIfNecessary(ChangeReportTaskData crtd) {
        if (crtd.getTransaction().isValid()) {
            ArrayList<Artifact> toReload = new ArrayList<Artifact>();
            for (ArtifactId id : crtd.getIds()) {
                Artifact cachedArt = ArtifactCache.getActive((ArtifactId)id, (BranchId)this.atsApi.getAtsBranch());
                if (cachedArt == null) continue;
                toReload.add(cachedArt);
            }
            if (!toReload.isEmpty()) {
                ArtifactQuery.reloadArtifacts(toReload);
            }
        }
    }

    public IAtsChangeReportTaskNameProvider getChangeReportOptionNameProvider(ChangeReportTaskNameProviderToken token) {
        return ChangeReportTaskNameProviderService.getChangeReportOptionNameProvider((ChangeReportTaskNameProviderToken)token);
    }

    public IAtsTask getTask(ArtifactToken artifact) {
        IAtsTask task = null;
        if (artifact instanceof IAtsTask) {
            task = (IAtsTask)artifact;
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
            task = new Task(this.atsApi.getLogger(), this.atsApi, artifact);
        } else {
            throw new OseeArgumentException("Artifact %s must be of type Task", new Object[]{artifact.toStringWithId()});
        }
        return task;
    }

    public NewTaskSet createTasks(NewTaskSet newTaskSet, Map<Long, IAtsTeamWorkflow> idToTeamWf) {
        throw new UnsupportedOperationException("Not supported on IDE client");
    }
}

