/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.review.ReviewFormalType;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionUtil;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.IsEnabled;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateFilteredTreeViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeListener;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewPeerReviewDialog
extends EntryDialog
implements IsEnabled {
    private String relatedToState = "";
    private String reviewFormalType = "";
    private String blockingType = "";
    private final Collection<String> relatedToStates;
    private final Collection<IAtsActionableItem> selectedAis;
    private final String defaultRelatedToState;
    private final Collection<IAtsActionableItem> ais;
    private CheckBoxStateFilteredTreeViewer<IAtsActionableItem> treeViewer;
    private XCombo relatedToStateCombo;
    private XCombo blockingTypeCombo;

    public NewPeerReviewDialog(String dialogTitle, String dialogMessage, Collection<String> relatedToStates, String defaultRelatedToState, Collection<IAtsActionableItem> ais) {
        super(dialogTitle, dialogMessage);
        this.relatedToStates = relatedToStates;
        this.defaultRelatedToState = defaultRelatedToState;
        this.ais = ais;
        this.selectedAis = new HashSet<IAtsActionableItem>();
    }

    protected void createExtendedArea(Composite parent) {
        Composite comboComp = new Composite(parent, 0);
        comboComp.setLayout((Layout)new GridLayout(6, false));
        GridData gd = new GridData(1536);
        gd.widthHint = 750;
        gd.horizontalSpan = 2;
        comboComp.setLayoutData((Object)gd);
        this.createReviewTypeCombo(comboComp);
        if (!this.isStandaloneReview()) {
            this.createRelatedToCombo(comboComp);
            this.createBlockingTypeCombo(comboComp);
        } else {
            this.createAisSelection(parent);
        }
    }

    private boolean isStandaloneReview() {
        return this.ais != null && !this.ais.isEmpty();
    }

    private void createAisSelection(Composite parent) {
        Pair<CheckBoxStateFilteredTreeViewer<IAtsActionableItem>, Text> results = NewActionUtil.createActionableItemTreeViewer(parent, null);
        this.treeViewer = (CheckBoxStateFilteredTreeViewer)results.getFirst();
        this.treeViewer.setEnabledChecker((IsEnabled)this);
        this.treeViewer.addCheckListener(new ICheckBoxStateTreeListener(){

            public void checkStateNodesChanged() {
                NewPeerReviewDialog.this.selectedAis.clear();
                for (Object obj : NewPeerReviewDialog.this.treeViewer.getChecked()) {
                    NewPeerReviewDialog.this.selectedAis.add((IAtsActionableItem)obj);
                }
                NewPeerReviewDialog.this.handleModified();
            }
        });
    }

    public Set<IAtsActionableItem> getSelectedActionableItems() {
        HashSet<IAtsActionableItem> selected = new HashSet<IAtsActionableItem>();
        for (Object obj : this.treeViewer.getChecked()) {
            selected.add((IAtsActionableItem)obj);
        }
        return selected;
    }

    private void createReviewTypeCombo(Composite parent) {
        final XCombo combo = new XCombo("Review Type");
        combo.setFillHorizontally(true);
        combo.setDataStrings(Arrays.asList(ReviewFormalType.InFormal.name(), ReviewFormalType.Formal.name()));
        combo.createWidgets(parent, 2);
        XModifiedListener listener = new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                NewPeerReviewDialog.this.reviewFormalType = combo.get();
                NewPeerReviewDialog.this.handleModified();
            }
        };
        combo.addXModifiedListener(listener);
    }

    private void createBlockingTypeCombo(Composite parent) {
        this.blockingTypeCombo = new XCombo("Blocking Type");
        this.blockingTypeCombo.setFillHorizontally(true);
        this.blockingTypeCombo.setDataStrings(Arrays.asList(ReviewBlockType.Commit.name(), ReviewBlockType.Transition.name()));
        this.blockingTypeCombo.createWidgets(parent, 2);
        XModifiedListener listener = new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                NewPeerReviewDialog.this.blockingType = NewPeerReviewDialog.this.blockingTypeCombo.get();
                NewPeerReviewDialog.this.handleModified();
            }
        };
        this.blockingTypeCombo.addXModifiedListener(listener);
    }

    private void createRelatedToCombo(Composite parent) {
        this.relatedToStateCombo = new XCombo("Related to State");
        this.relatedToStateCombo.setFillHorizontally(true);
        this.relatedToStateCombo.setDataStrings(this.relatedToStates);
        if (Strings.isValid((String)this.defaultRelatedToState)) {
            this.relatedToStateCombo.setDataStrings(new String[]{this.defaultRelatedToState});
        }
        this.relatedToStateCombo.createWidgets(parent, 2);
        XModifiedListener listener = new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                NewPeerReviewDialog.this.relatedToState = NewPeerReviewDialog.this.relatedToStateCombo.get();
                NewPeerReviewDialog.this.handleModified();
            }
        };
        this.relatedToStateCombo.addXModifiedListener(listener);
    }

    public boolean isEntryValid() {
        if (!super.isEntryValid()) {
            return false;
        }
        if (!Strings.isValid((String)this.getEntry())) {
            this.setErrorString("Must enter Title");
            return false;
        }
        if (!Strings.isValid((String)this.getReviewFormalType())) {
            this.setErrorString("Must select Review Type");
            return false;
        }
        if (this.treeViewer != null) {
            if (this.selectedAis.isEmpty()) {
                this.setErrorString("Must select Actionable Item");
                return false;
            }
            if (this.selectedAis.size() > 1) {
                this.setErrorString("Only select 1 Actionable Item");
                return false;
            }
            IAtsActionableItem ai = this.selectedAis.iterator().next();
            IAtsTeamDefinition teamDef = ai.getAtsApi().getActionableItemService().getTeamDefinitionInherited(ai);
            if (teamDef == null) {
                AWorkbench.popup((String)"No related Team Definition for selected Actionable Item.  Choose another");
                this.treeViewer.setChecked((Object)ai, false);
            }
        }
        return true;
    }

    public String getRelatedToState() {
        return this.relatedToState;
    }

    public String getReviewFormalType() {
        return this.reviewFormalType;
    }

    public String getBlockingType() {
        return this.blockingType;
    }

    public void setReviewTitle(String defaultReviewTitle) {
        this.setEntry(defaultReviewTitle);
    }

    public String getReviewTitle() {
        return this.getEntry();
    }

    public String getSelectedState() {
        return this.relatedToStateCombo.get();
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.handleModified();
        return control;
    }

    public boolean isEnabled(Object obj) {
        if (obj instanceof IAtsActionableItem) {
            return ((IAtsActionableItem)obj).isActive() && ((IAtsActionableItem)obj).isActionable();
        }
        return false;
    }
}

