/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public abstract class AbstractReviewArtifact
extends AbstractWorkflowArtifact
implements IAtsAbstractReview {
    public AbstractReviewArtifact(Long id, String guid, BranchToken branch, ArtifactTypeToken artifactType) {
        super(id, guid, branch, artifactType);
    }

    public static List<AtsUser> getImplementersByState(AbstractWorkflowArtifact workflow, IStateToken state) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        if (workflow.isCancelled()) {
            users.add(workflow.getCancelledBy());
        } else {
            AtsUser user2;
            for (AtsUser user2 : workflow.getStateMgr().getAssignees(state.getName())) {
                if (users.contains(user2)) continue;
                users.add(user2);
            }
            if (workflow.isCompleted() && (user2 = workflow.getCompletedBy()) != null && !users.contains(user2)) {
                users.add(user2);
            }
        }
        return users;
    }

    public boolean isBlocking() {
        return this.getReviewBlockType() != ReviewBlockType.None;
    }

    public ReviewBlockType getReviewBlockType() {
        String typeStr = (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.ReviewBlocks, null);
        if (typeStr == null) {
            return ReviewBlockType.None;
        }
        return ReviewBlockType.valueOf((String)typeStr);
    }

    @Override
    public AbstractWorkflowArtifact getParentAWA() {
        if (this.isStandAloneReview()) {
            return null;
        }
        if (this.parentAwa != null) {
            return this.parentAwa;
        }
        this.parentAwa = (AbstractWorkflowArtifact)this.getParentTeamWorkflow();
        return this.parentAwa;
    }

    @Override
    public IAtsAction getParentAction() {
        if (this.isStandAloneReview()) {
            return null;
        }
        if (this.parentAction != null) {
            return this.parentAction;
        }
        this.parentTeamArt = (TeamWorkFlowArtifact)this.getParentTeamWorkflow();
        if (this.parentTeamArt != null) {
            this.parentAction = this.parentTeamArt.getParentAction();
        }
        return this.parentAction;
    }

    @Override
    public IAtsTeamWorkflow getParentTeamWorkflow() {
        if (this.isStandAloneReview() || this.isDeleted()) {
            return null;
        }
        if (this.parentTeamArt != null) {
            return this.parentTeamArt;
        }
        List teams = this.getRelatedArtifacts(AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow, TeamWorkFlowArtifact.class);
        if (teams.size() > 1) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)(String.valueOf(this.getArtifactTypeName()) + " " + this.getAtsId() + " has multiple parent workflows"));
        } else if (!this.isStandAloneReview() && teams.isEmpty() && !this.isDeleted()) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)(String.valueOf(this.getArtifactTypeName()) + " " + this.getAtsId() + " has no parent workflow"));
        }
        if (!teams.isEmpty()) {
            this.parentTeamArt = (TeamWorkFlowArtifact)((Object)teams.iterator().next());
        }
        return this.parentTeamArt;
    }

    public Artifact getArtifact() {
        return this;
    }

    public static AbstractReviewArtifact cast(Artifact artifact) {
        if (artifact instanceof AbstractReviewArtifact) {
            return (AbstractReviewArtifact)artifact;
        }
        return null;
    }

    public Set<IAtsActionableItem> getActionableItems() {
        return AtsApiService.get().getActionableItemService().getActionableItems((IAtsWorkItem)this);
    }

    public String getRelatedToState() {
        return (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.RelatedToState, "");
    }

    public boolean isStandAloneReview() {
        return !this.getActionableItems().isEmpty();
    }
}

