/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnToken;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class OpenAgileTasksAction
extends Action {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private String agileCard;

    public OpenAgileTasksAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Open Agile Task Cards for Selected");
        this.selectedAtsArtifacts = selectedAtsArtifacts;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.PRINT);
    }

    public void run() {
        try {
            List<Artifact> selected = this.selectedAtsArtifacts.getSelectedAtsArtifacts();
            if (selected.isEmpty()) {
                AWorkbench.popup((String)"No items selected");
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<table class=\"fixed\" border=\"2\" cellpadding=\"3\" cellspacing=\"0\" width=\"100\">");
            Artifact[] arts = selected.toArray(new Artifact[selected.size()]);
            int x = 0;
            while (x < arts.length) {
                String firstCard = this.getCardHtml(arts[x]);
                String secondCard = "";
                if (arts.length != x + 1) {
                    secondCard = this.getCardHtml(arts[x + 1]);
                }
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{firstCard, secondCard}));
                x += 2;
            }
            sb.append(AHTML.endMultiColumnTable());
            ResultsEditor.open((String)"Agile Tasks", (String)"Agile Tasks", (String)sb.toString());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private String getCardHtml(Artifact artifact) {
        String card = "";
        if (artifact instanceof IAtsWorkItem) {
            card = this.getCardTemplate();
            IAtsWorkItem workItem = (IAtsWorkItem)artifact;
            card = card.replaceFirst("PUT_TITLE_HERE", workItem.getName());
            card = card.replaceFirst("PUT_POINTS_HERE", AtsApiService.get().getAgileService().getAgileTeamPointsStr(workItem));
            card = card.replaceFirst("PUT_FEATURE_HERE", AtsApiService.get().getAgileService().getAgileFeatureGroupStr(workItem));
            card = card.replaceFirst("PUT_CHANGE_TYPE_HERE", ChangeTypeColumn.getChangeTypeStr((IAtsWorkItem)workItem, (AtsApi)AtsApiService.get()));
            card = card.replaceFirst("PUT_PRIORITY_HERE", AtsApiService.get().getColumnService().getColumnText((AtsColumnToken)AtsColumnTokens.PriorityColumn, (IAtsObject)workItem));
            card = card.replaceFirst("PUT_ASSIGNEES_HERE", AtsApiService.get().getColumnService().getColumnText((AtsColumnToken)AtsColumnTokens.AssigneeColumn, (IAtsObject)workItem));
            card = card.replaceFirst("PUT_ATSID_HERE", AtsApiService.get().getColumnService().getColumnText((AtsColumnToken)AtsColumnTokens.AtsIdColumn, (IAtsObject)workItem));
            card = card.replaceFirst("PUT_AI_HERE", AtsApiService.get().getColumnService().getColumnText((AtsColumnToken)AtsColumnTokens.ActionableItemsColumn, (IAtsObject)workItem));
            card = card.replaceFirst("PUT_VERSION_HERE", AtsApiService.get().getColumnService().getColumnText((AtsColumnToken)AtsColumnTokens.TargetedVersionColumn, (IAtsObject)workItem));
        }
        return card;
    }

    private String getCardTemplate() {
        if (this.agileCard == null) {
            this.agileCard = OseeInf.getResourceContents((String)"templates/agileCard.html", OpenAgileTasksAction.class);
            return OseeInf.getResourceContents((String)"templates/agileCard.html", OpenAgileTasksAction.class);
        }
        return this.agileCard;
    }

    public static interface RemovedFromCollectorHandler {
        public void removedFromCollector(Collection<? extends Artifact> var1);
    }
}

