/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AITreeContentProvider;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.ArtifactNameSorter;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AICheckTreeDialog
extends FilteredCheckboxTreeDialog<IAtsActionableItem> {
    private final Active active;
    private Collection<IAtsActionableItem> initialAias;

    public AICheckTreeDialog(String title, String message, Active active) {
        super(title, message, (IContentProvider)new AITreeContentProvider(active), (IBaseLabelProvider)new AtsObjectLabelProvider(), (ViewerComparator)new ArtifactNameSorter());
        this.active = active;
    }

    public Collection<IAtsActionableItem> getChecked() {
        return super.getTreeViewer().getChecked();
    }

    protected Control createDialogArea(Composite container) {
        Control comp = super.createDialogArea(container);
        try {
            this.getTreeViewer().getViewer().setInput((Object)AtsApiService.get().getActionableItemService().getTopLevelActionableItems(this.active));
            this.getTreeViewer().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    try {
                        for (IAtsActionableItem aia : AICheckTreeDialog.this.getChecked()) {
                            if (aia.isActionable()) continue;
                            AWorkbench.popup((String)"ERROR", (String)AtsApiService.get().getActionableItemService().getNotActionableItemError((IAtsConfigObject)aia));
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
            if (this.getInitialAias() != null) {
                this.getTreeViewer().setInitalChecked(this.getInitialAias());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return comp;
    }

    protected Result isComplete() {
        try {
            for (IAtsActionableItem aia : this.getChecked()) {
                if (aia.isActionable()) continue;
                return Result.FalseResult;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return super.isComplete();
    }

    public Collection<IAtsActionableItem> getInitialAias() {
        return this.initialAias;
    }

    public void setInitialAias(Collection<IAtsActionableItem> initialAias) {
        this.initialAias = initialAias;
    }
}

