/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionListDialog;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Widget;

public class XHyperlabelVersionSelection
extends XHyperlinkLabelValueSelection {
    Version selectedVersion = null;
    Collection<IAtsVersion> selectableVersions;
    VersionListDialog dialog = null;
    protected AtsApi atsApi = AtsApiService.get();

    public XHyperlabelVersionSelection() {
        this("Version");
    }

    public XHyperlabelVersionSelection(String label) {
        super(label);
    }

    public Version getSelectedVersion() {
        return this.selectedVersion;
    }

    public Object getData() {
        return this.getSelectedVersion();
    }

    public String getCurrentValue() {
        if (this.selectedVersion == null) {
            return Widgets.NOT_SET;
        }
        return this.selectedVersion.getName();
    }

    public boolean handleClear() {
        this.selectedVersion = null;
        this.notifyXModifiedListeners();
        return true;
    }

    public void setSelectedVersion(Version selectedVersion) {
        this.selectedVersion = selectedVersion;
        this.refresh();
        this.notifyXModifiedListeners();
    }

    public boolean handleSelection() {
        try {
            this.dialog = this.selectableVersions == null ? new VersionListDialog("Select Version", "Select Version", this.getSelectableVersions()) : new VersionListDialog("Select Version", "Select Version", this.selectableVersions);
            this.dialog.setRemoveAllAllowed(false);
            int result = this.dialog.open();
            if (result == 0) {
                Version version;
                this.selectedVersion = version = (Version)this.dialog.getSelectedFirst();
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public IStatus isValid() {
        if (this.isRequiredEntry() && this.isEmpty()) {
            return new Status(4, "org.eclipse.osee.ats.ide", String.valueOf(this.getLabel()) + " must be selected.");
        }
        return Status.OK_STATUS;
    }

    public Collection<IAtsVersion> getSelectableVersions() {
        return this.selectableVersions;
    }

    public void setSelectableVersions(Collection<IAtsVersion> versions) {
        this.selectableVersions = versions;
    }

    public boolean isEmpty() {
        return this.selectedVersion == null;
    }

    public void setEnableHyperLink() {
        if (Widgets.isAccessible((Widget)this.labelHyperlink)) {
            this.labelHyperlink.setEnabled(true);
        }
    }

    public void setDisableHyperLink() {
        if (Widgets.isAccessible((Widget)this.labelHyperlink)) {
            this.labelHyperlink.setEnabled(false);
        }
    }
}

