/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.util.Import.ExcelAtsTaskArtifactExtractor;
import org.eclipse.osee.ats.ide.util.Import.TaskImportJob;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XButtonPush;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImportTasksFromSpreadsheet
extends AbstractBlam {
    private static final String OPEN_EXCEL_IMPORT_EXAMPLE_SPREADSHEET = "Open Excel Import Example Spreadsheet";
    public static final String TASK_IMPORT_SPREADSHEET = "Task Import Spreadsheet";
    public static final String TEAM_WORKFLOW = "Taskable Workflow (drop here)";
    public static final String EMAIL_POCS = "Email POCs";
    public static final String FIX_TITLES = "Fix Titles (remove non-printable chars and truncate)";
    private TeamWorkFlowArtifact taskableStateMachineArtifact;
    public static final String INVALID_BLAM_CAUSE = "Invalid BLAM Spreadsheet";
    private NewTaskSet newTaskSet;

    public String getName() {
        return "Import Tasks From Spreadsheet";
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(TEAM_WORKFLOW) && this.taskableStateMachineArtifact != null) {
            XListDropViewer viewer = (XListDropViewer)xWidget;
            viewer.setInput(Arrays.asList(new Object[]{this.taskableStateMachineArtifact}));
        }
        if (xWidget.getLabel().equals(OPEN_EXCEL_IMPORT_EXAMPLE_SPREADSHEET)) {
            XButtonPush button = (XButtonPush)xWidget;
            button.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    try {
                        File file = ImportTasksFromSpreadsheet.this.getSampleSpreadsheetFile();
                        Program.launch((String)file.getCanonicalPath());
                    }
                    catch (Exception ex) {
                        ImportTasksFromSpreadsheet.this.log(ex);
                    }
                }
            });
        }
    }

    public File getSampleSpreadsheetFile() throws Exception {
        return OseeInf.getResourceAsFile((String)"atsImport/Task_Import.xml", ((Object)((Object)this)).getClass());
    }

    public String getXWidgetsXml() {
        StringBuffer buffer = new StringBuffer("<xWidgets>");
        buffer.append("<XWidget xwidgetType=\"XButtonPush\" displayName=\"Open Excel Import Example Spreadsheet\" displayLabel=\"false\"/>");
        buffer.append("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"Taskable Workflow (drop here)\" />");
        buffer.append("<XWidget xwidgetType=\"XFileSelectionDialog\" displayName=\"Task Import Spreadsheet\" />");
        buffer.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Fix Titles (remove non-printable chars and truncate)\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
        buffer.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Email POCs\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
        buffer.append("</xWidgets>");
        return buffer.toString();
    }

    public String getDescriptionUsage() {
        return "Import tasks from spreadsheet into given Team Workflow.  After \"Notes\" column, remaining columns will attempt to match column name with valid attribute type name add that to workflow.";
    }

    public void setTaskableStateMachineArtifact(TeamWorkFlowArtifact taskableStateMachineArtifact) {
        this.taskableStateMachineArtifact = taskableStateMachineArtifact;
    }

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        this.newTaskSet = NewTaskSet.create((String)this.getName(), (String)AtsApiService.get().getUserService().getCurrentUserId());
        this.newTaskSet.getResults().setTitle(this.getName());
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List artifacts = variableMap.getArtifacts(ImportTasksFromSpreadsheet.TEAM_WORKFLOW);
                    String filename = variableMap.getString(ImportTasksFromSpreadsheet.TASK_IMPORT_SPREADSHEET);
                    boolean emailPocs = variableMap.getBoolean(ImportTasksFromSpreadsheet.EMAIL_POCS);
                    boolean fixTitles = variableMap.getBoolean(ImportTasksFromSpreadsheet.FIX_TITLES);
                    if (artifacts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in Team Workflow to add tasks.");
                        return;
                    }
                    if (artifacts.size() > 1) {
                        AWorkbench.popup((String)"ERROR", (String)"Only drag ONE Team Workflow.");
                        return;
                    }
                    Artifact artifact = (Artifact)artifacts.iterator().next();
                    if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                        AWorkbench.popup((String)"ERROR", (String)"Artifact MUST be Team Workflow");
                        return;
                    }
                    if (!Strings.isValid((String)filename)) {
                        AWorkbench.popup((String)"ERROR", (String)"Must enter valid filename.");
                        return;
                    }
                    File file = new File(filename);
                    try {
                        WorkflowEditor editor = WorkflowEditor.getWorkflowEditor((TeamWorkFlowArtifact)artifact);
                        if (editor != null) {
                            editor.close(true);
                        }
                        ImportTasksFromSpreadsheet.this.performImport(fixTitles, emailPocs, (TeamWorkFlowArtifact)artifact, file);
                        Thread.sleep(2000L);
                        WorkflowEditor.edit((TeamWorkFlowArtifact)artifact);
                        editor = WorkflowEditor.getWorkflowEditor((TeamWorkFlowArtifact)artifact);
                        editor.setPage(1);
                    }
                    catch (Exception ex) {
                        ImportTasksFromSpreadsheet.this.log(ex);
                    }
                    if (ImportTasksFromSpreadsheet.this.newTaskSet.getResults().isErrors()) {
                        XResultDataUI.report((XResultData)ImportTasksFromSpreadsheet.this.newTaskSet.getResults(), (String)("Error: " + ImportTasksFromSpreadsheet.this.getName()));
                    }
                }
                catch (Exception ex) {
                    ImportTasksFromSpreadsheet.this.log(ex);
                }
            }
        });
    }

    public NewTaskSet performImport(boolean fixTitles, boolean emailPocs, IAtsTeamWorkflow teamWf, File file) {
        try {
            AtsUtilClient.setEmailEnabled(emailPocs);
            NewTaskData newTaskData = new NewTaskData();
            ArrayList<NewTaskData> newTaskDatas = new ArrayList<NewTaskData>();
            newTaskDatas.add(newTaskData);
            if (this.newTaskSet == null) {
                this.newTaskSet = NewTaskSet.create((String)this.getName(), (String)AtsApiService.get().getUserService().getCurrentUserId());
            }
            this.newTaskSet.getResults().log(this.getName());
            this.newTaskSet.setTaskDatas(newTaskDatas);
            this.newTaskSet.getTaskData().setTeamWfId(teamWf.getId());
            this.newTaskSet.getTaskData().setFixTitles(Boolean.valueOf(fixTitles));
            XResultData rd = this.newTaskSet.getResults();
            Job job = Jobs.startJob((Job)new TaskImportJob(file, new ExcelAtsTaskArtifactExtractor((TeamWorkFlowArtifact)teamWf.getStoreObject(), this.newTaskSet.getTaskData()), rd));
            job.join();
            if (rd.isSuccess()) {
                NewTaskSet newTaskSet = AtsApiService.get().getTaskService().createTasks(this.newTaskSet);
                return newTaskSet;
            }
        }
        catch (Exception ex) {
            this.newTaskSet.getResults().errorf("Exception in %s: %s\n", new Object[]{this.getName(), Lib.exceptionToString((Exception)ex)});
        }
        finally {
            AtsUtilClient.setEmailEnabled(true);
        }
        return this.newTaskSet;
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_IMPORT);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.IMPORT);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.IMPORT);
    }
}

