/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditor;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditorSimpleProvider;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkflowLabelProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.ats.ide.world.WorldEditorUISearchItemProvider;
import org.eclipse.osee.ats.ide.world.search.GroupWorldSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.FrameworkArtifactImageProvider;
import org.eclipse.osee.framework.ui.skynet.cm.OseeCmEditor;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ListDialog;

public final class AtsEditors {
    private AtsEditors() {
    }

    public static void openArtifactById(ArtifactId artifactId, OseeCmEditor editor) {
        try {
            Artifact artifact = ArtifactQuery.getArtifactFromId((ArtifactId)artifactId, (BranchId)AtsApiService.get().getAtsBranch());
            AtsEditors.openArtifact(artifact, editor);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static void openArtifact(Artifact artifact, OseeCmEditor editor) {
        try {
            if (editor == OseeCmEditor.CmPcrEditor) {
                if (artifact instanceof AbstractWorkflowArtifact || artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                    AtsEditors.openATSAction((ArtifactToken)artifact, AtsOpenOption.OpenOneOrPopupSelect);
                } else {
                    RendererManager.open((Artifact)artifact, (PresentationType)PresentationType.GENERALIZED_EDIT);
                }
            } else if (editor == OseeCmEditor.ArtifactEditor) {
                RendererManager.open((Artifact)artifact, (PresentationType)PresentationType.GENERALIZED_EDIT);
            } else if (editor == OseeCmEditor.ArtifactHyperViewer) {
                AWorkbench.popup((String)"ERROR", (String)"Unimplemented");
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static void openATSArtifact(ArtifactToken artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) {
            try {
                AtsEditors.openATSAction(artifact, AtsOpenOption.OpenOneOrPopupSelect);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                AWorkbench.popup((String)"ERROR", (String)ex.getLocalizedMessage());
            }
        } else {
            AWorkbench.popup((String)"ERROR", (String)String.format("Trying to open %s with SMAEditor", artifact.toStringWithId()));
        }
    }

    public static void openATSAction(ArtifactToken art, AtsOpenOption atsOpenOption) {
        try {
            final Artifact artifact = ArtifactQuery.getArtifactFromId((ArtifactId)art, (BranchId)AtsApiService.get().getAtsBranch());
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                IAtsAction action = (IAtsAction)artifact;
                Collection teams = AtsApiService.get().getWorkItemService().getTeams((Object)artifact);
                if (atsOpenOption == AtsOpenOption.OpenAll) {
                    for (IAtsTeamWorkflow team : teams) {
                        WorkflowEditor.edit((IAtsWorkItem)team);
                    }
                } else if (atsOpenOption == AtsOpenOption.AtsWorld) {
                    WorldEditor.open(new WorldEditorSimpleProvider("Action " + action.getAtsId(), Arrays.asList(artifact)));
                } else if (atsOpenOption == AtsOpenOption.OpenOneOrPopupSelect) {
                    if (teams.size() == 1) {
                        WorkflowEditor.edit((IAtsWorkItem)teams.iterator().next());
                    } else {
                        Displays.ensureInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    TeamWorkFlowArtifact teamArt = AtsEditors.promptSelectTeamWorkflow(artifact);
                                    if (teamArt == null) {
                                        return;
                                    }
                                    WorkflowEditor.editArtifact(teamArt);
                                }
                                catch (OseeCoreException ex) {
                                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                                }
                            }
                        });
                    }
                }
            } else {
                WorkflowEditor.editArtifact(artifact);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static TeamWorkFlowArtifact promptSelectTeamWorkflow(Artifact actArt) {
        ListDialog ld = new ListDialog(Displays.getActiveShell());
        ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        ld.setLabelProvider((ILabelProvider)new TeamWorkflowLabelProvider());
        ld.setTitle("Select Team Workflow");
        ld.setMessage("Select Team Workflow");
        ld.setInput((Object)AtsApiService.get().getWorkItemService().getTeams((Object)actArt));
        if (ld.open() == 0) {
            if (ld.getResult().length == 0) {
                AWorkbench.popup((String)"Error", (String)"No Workflow Selected");
            } else {
                return (TeamWorkFlowArtifact)((Object)ld.getResult()[0]);
            }
        }
        return null;
    }

    public static void openInAtsWorldEditor(Collection<? extends IAtsWorkItem> workItems, String name) {
        AtsEditors.openInAtsWorldEditor(name, AtsObjects.getArtifacts(workItems));
    }

    public static void openInAtsWorldEditor(String name, Collection<? extends ArtifactId> artifacts) {
        HashSet<Artifact> otherArts = new HashSet<Artifact>();
        for (ArtifactId artifactId : artifacts) {
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(artifactId);
            if (art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.UniversalGroup})) {
                WorldEditor.open(new WorldEditorUISearchItemProvider(new GroupWorldSearchItem(art), null, XNavigateComposite.TableLoadOption.None));
                continue;
            }
            otherArts.add(art);
        }
        if (otherArts.size() > 0) {
            WorldEditor.open(new WorldEditorSimpleProvider(name, otherArts));
        }
    }

    public static void openInAtsWorldEditor(String name, Collection<? extends Artifact> artifacts, CustomizeData customizeData) {
        HashSet<Artifact> otherArts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.UniversalGroup})) {
                WorldEditor.open(new WorldEditorUISearchItemProvider(new GroupWorldSearchItem(artifact), null, XNavigateComposite.TableLoadOption.None));
                continue;
            }
            otherArts.add(artifact);
        }
        if (otherArts.size() > 0) {
            WorldEditor.open(new WorldEditorSimpleProvider(name, otherArts, customizeData, new XNavigateComposite.TableLoadOption[0]));
        }
    }

    public static void openInAtsWorldEditor(String name, List<IAtsTeamWorkflow> newTeamWfs) {
        AtsEditors.openInAtsWorldEditor(name, AtsObjects.getArtifacts(newTeamWfs));
    }

    public static void openInAtsTaskEditor(String name, Collection<Artifact> artifacts) {
        TaskEditor.open(new TaskEditorSimpleProvider(name, artifacts));
    }

    public static Set<Artifact> getAssigned(AtsUser user) {
        HashSet<Artifact> assigned = new HashSet<Artifact>();
        for (Artifact artifact : ArtifactQuery.getArtifactListFromAttribute((AttributeTypeId)AtsAttributeTypes.CurrentState, (String)("<" + user.getUserId() + ">"), (BranchId)AtsApiService.get().getAtsBranch(), (QueryOption[])QueryOption.CONTAINS_MATCH_OPTIONS)) {
            assigned.add(artifact);
        }
        return assigned;
    }

    public static Image getImage(Collection<AtsUser> atsUsers) {
        HashSet<User> users = new HashSet<User>();
        for (AtsUser user : atsUsers) {
            users.add((User)AtsApiService.get().getUserService().getUserByUserId(user.getUserId()).getStoreObject());
        }
        return FrameworkArtifactImageProvider.getUserImage(users);
    }

    public static void openAction(IAtsAction action, AtsOpenOption atsOpenOption) {
        AtsEditors.openATSAction(action.getStoreObject(), atsOpenOption);
    }

    public static XViewerAlign getXViewerAlign(ColumnAlign columnAlign) {
        if (columnAlign == ColumnAlign.Center) {
            return XViewerAlign.Center;
        }
        if (columnAlign == ColumnAlign.Right) {
            return XViewerAlign.Right;
        }
        return XViewerAlign.Left;
    }

    public static ColumnAlign getColumnAlign(XViewerAlign xViewerAlign) {
        if (xViewerAlign == XViewerAlign.Center) {
            return ColumnAlign.Center;
        }
        if (xViewerAlign == XViewerAlign.Right) {
            return ColumnAlign.Right;
        }
        return ColumnAlign.Left;
    }
}

