/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.metrics;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelTeamDefinitionSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelVersionSelection;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XDateDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DevProgressMetricsBlam
extends AbstractBlam {
    private static final String NAME = "Development Progress Metrics BLAM";
    private static final String TEAM_DEFINITIONS = "Team Definition(s)";
    private static final String VERSION = "Version";
    private static final String START_DATE = "Start Date";
    private static final String END_DATE = "End Date";
    private static final String DAY_OF_WEEK = "Select they day of the week (Default - Monday)";
    private static final String DURATION = "Select they length of iteration (Default - Weekly)";
    private static final String SHOW_PERIODIC = "Show Periodic Workflow Table";
    private static final String SHOW_NONPERIODIC = "Show Workflow Table";
    private static final String SHOW_PERIODIC_TASK = "Show Periodic Task Table";
    private static final String SHOW_NONPERIODIC_TASK = "Show Task Table";
    private XHyperlabelTeamDefinitionSelection programWidget;
    private XHyperlabelVersionSelection versionWidget;
    private XDateDam startDateWidget;
    private XDateDam endDateWidget;
    private Date startDate;
    private Date endDate;
    private int dayOfWeek;
    private boolean showPeriodic;
    private boolean showNonPeriodic;
    private boolean showPeriodicTask;
    private boolean showNonPeriodicTask;
    private int duration;
    private Collection<IAtsVersion> versions;

    public String getName() {
        return NAME;
    }

    public String getDescriptionUsage() {
        return "Generates SLOC Productivity Report based on Version";
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        if (xWidget.getLabel().equalsIgnoreCase(VERSION)) {
            this.versions = new ArrayList<IAtsVersion>();
            this.versionWidget = (XHyperlabelVersionSelection)xWidget;
            this.versionWidget.getLabelHyperlink().redraw();
        } else if (xWidget.getLabel().equals(TEAM_DEFINITIONS)) {
            this.programWidget = (XHyperlabelTeamDefinitionSelection)xWidget;
            this.programWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    DevProgressMetricsBlam.this.setProgramVersions();
                    DevProgressMetricsBlam.this.versionWidget.setSelectableVersions(DevProgressMetricsBlam.this.versions);
                    DevProgressMetricsBlam.this.versionWidget.getLabelHyperlink().redraw();
                }
            });
        } else if (xWidget.getLabel().equalsIgnoreCase(START_DATE)) {
            this.startDateWidget = (XDateDam)xWidget;
            this.initializeWidgets();
        } else if (xWidget.getLabel().equalsIgnoreCase(END_DATE)) {
            this.endDateWidget = (XDateDam)xWidget;
            this.initializeWidgets();
        }
    }

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Version selectedVersion = DevProgressMetricsBlam.this.versionWidget.getSelectedVersion();
                    DevProgressMetricsBlam.this.startDate = (Date)variableMap.getValue(DevProgressMetricsBlam.START_DATE);
                    DevProgressMetricsBlam.this.endDate = (Date)variableMap.getValue(DevProgressMetricsBlam.END_DATE);
                    DevProgressMetricsBlam.this.dayOfWeek = DevProgressMetricsBlam.getDayOfWeekAsInt(variableMap.getString(DevProgressMetricsBlam.DAY_OF_WEEK));
                    DevProgressMetricsBlam.this.duration = DevProgressMetricsBlam.getIterationInt(variableMap.getString(DevProgressMetricsBlam.DURATION));
                    DevProgressMetricsBlam.this.showPeriodic = variableMap.getBoolean(DevProgressMetricsBlam.SHOW_PERIODIC);
                    DevProgressMetricsBlam.this.showNonPeriodic = variableMap.getBoolean(DevProgressMetricsBlam.SHOW_NONPERIODIC);
                    DevProgressMetricsBlam.this.showPeriodicTask = variableMap.getBoolean(DevProgressMetricsBlam.SHOW_PERIODIC_TASK);
                    DevProgressMetricsBlam.this.showNonPeriodicTask = variableMap.getBoolean(DevProgressMetricsBlam.SHOW_NONPERIODIC_TASK);
                    AtsApiService.get().getServerEndpoints().getMetricsEp().devProgressReport(selectedVersion.getName(), DevProgressMetricsBlam.this.startDate, DevProgressMetricsBlam.this.endDate, DevProgressMetricsBlam.this.dayOfWeek, DevProgressMetricsBlam.this.duration, DevProgressMetricsBlam.this.showPeriodic, DevProgressMetricsBlam.this.showNonPeriodic, DevProgressMetricsBlam.this.showPeriodicTask, DevProgressMetricsBlam.this.showNonPeriodicTask);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.REPORTS);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        XWidgetBuilder wb = new XWidgetBuilder();
        wb.andWidget(TEAM_DEFINITIONS, "XHyperlabelTeamDefinitionSelection").endWidget();
        wb.andWidget(VERSION, "XHyperlabelVersionSelection").endWidget();
        wb.andWidget(START_DATE, "XDateDam").endWidget();
        wb.andWidget(END_DATE, "XDateDam").endWidget();
        wb.andWidget(DAY_OF_WEEK, this.getWeekdaysXCombo()).andDefault((Object)"Monday").endWidget();
        wb.andWidget(DURATION, "XCombo(Week,1-Day,3-Days)").andDefault((Object)"Week").endWidget();
        wb.andWidget(SHOW_NONPERIODIC, "XCheckBox").endWidget();
        wb.andWidget(SHOW_NONPERIODIC_TASK, "XCheckBox").endWidget();
        wb.andWidget(SHOW_PERIODIC, "XCheckBox").endWidget();
        wb.andWidget(SHOW_PERIODIC_TASK, "XCheckBox").endWidget();
        return wb.getItems();
    }

    public void setProgramVersions() {
        HashSet versionSet = new HashSet();
        Collection<TeamDefinition> teamDefs = this.programWidget.getSelectedTeamDefintions();
        for (IAtsTeamDefinition iAtsTeamDefinition : teamDefs) {
            if (!iAtsTeamDefinition.isValid()) continue;
            versionSet.addAll(AtsApiService.get().getVersionService().getVersionsFromTeamDefHoldingVersions(iAtsTeamDefinition));
        }
        this.versions.clear();
        this.versions.addAll(versionSet);
    }

    private void initializeWidgets() {
        if (this.startDateWidget != null) {
            this.initializeStartDate();
        }
        if (this.endDateWidget != null) {
            this.endDateWidget.setDate(Calendar.getInstance().getTime());
        }
    }

    private void initializeStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        this.startDateWidget.setDate(cal.getTime());
    }

    private String getWeekdaysXCombo() {
        StringBuilder builder = new StringBuilder();
        String[] weekdays = new DateFormatSymbols().getWeekdays();
        builder.append("XCombo(");
        int i = 1;
        while (i < 8) {
            if (i != 1) {
                builder.append(",");
            }
            builder.append(weekdays[i]);
            ++i;
        }
        builder.append(")");
        return builder.toString();
    }

    public static int getDayOfWeekAsInt(String dayAsString) {
        int toReturn = 2;
        try {
            if (!dayAsString.contains("select")) {
                Days day = Days.valueOf(dayAsString.toUpperCase());
                toReturn = day.ordinal() + 1;
            }
        }
        catch (Exception exception) {}
        return toReturn;
    }

    public static int getIterationInt(String durationString) {
        int toReturn = 7;
        try {
            if (durationString.equals("1-Day")) {
                toReturn = 1;
            } else if (durationString.equals("3-Days")) {
                toReturn = 3;
            }
        }
        catch (Exception exception) {}
        return toReturn;
    }

    public static enum Days {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;

    }
}

