/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.journal;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.workflow.AtsActionEndpointApi;
import org.eclipse.osee.ats.api.workflow.journal.JournalData;
import org.eclipse.osee.ats.core.workflow.AtsWorkItemServiceImpl;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.journal.WfeJournalSubscribersComp;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeJournalTab
extends WfeAbstractTab {
    private Composite bodyComp;
    public static final String ID = "ats.journal.tab";
    private final IAtsWorkItem workItem;
    private Browser browser;
    private final WorkflowEditor editor;
    private final AtsApiIde atsApi;
    private IManagedForm managedForm;
    private WfeJournalSubscribersComp journalComp;
    private JournalData journalData;
    private XText text;
    private Button submitButton;
    private Button openJournalOnWebButton;

    public WfeJournalTab(WorkflowEditor editor, IAtsWorkItem workItem, AtsApiIde atsApi) {
        super(editor, ID, workItem, "Journal");
        this.editor = editor;
        this.workItem = workItem;
        this.atsApi = atsApi;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.managedForm = managedForm;
        try {
            this.bodyComp = managedForm.getForm().getBody();
            GridLayout gridLayout = new GridLayout(1, true);
            this.bodyComp.setLayout((Layout)gridLayout);
            GridData gd = new GridData(16384, 16384, true, true);
            this.bodyComp.setLayoutData((Object)gd);
            this.createWidgets();
            this.createBrowser();
            this.updateTitleBar(managedForm);
            this.createToolbar(managedForm);
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
            managedForm.reflow(true);
            this.refresh();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refreshTabName() {
        if (this.editor.isDisposed()) {
            return;
        }
        String tabName = "Journal";
        try {
            int count = AtsApiService.get().getAttributeResolver().getAttributeCount(this.workItem, (AttributeTypeToken)AtsAttributeTypes.Journal);
            if (count > 0) {
                tabName = "Journal(*)";
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        this.setPartName(tabName);
    }

    private void createWidgets() {
        Composite composite = new Composite(this.bodyComp, 0);
        composite.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getManagedForm().getToolkit().adapt(composite);
        this.journalComp = new WfeJournalSubscribersComp(composite, 0, this.workItem, this.workItem.isInWork(), this.editor);
        this.openJournalOnWebButton = new Button(composite, 8);
        this.openJournalOnWebButton.setText("Open Journal on Web");
        this.managedForm.getToolkit().adapt((Control)this.openJournalOnWebButton, true, true);
        this.openJournalOnWebButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)AtsWorkItemServiceImpl.getJournalUrl((String)WfeJournalTab.this.atsApi.getAtsId((IAtsObject)WfeJournalTab.this.workItem).toString(), (String)WfeJournalTab.this.atsApi.getUserService().getCurrentUser().getIdString(), (AtsApi)WfeJournalTab.this.atsApi));
            }
        });
        this.text = new XText("New Entry");
        this.text.setVerticalLabel(true);
        this.text.setFillHorizontally(true);
        this.text.setFillVertically(true);
        this.text.createWidgets(composite, 1);
        GridData gd = new GridData(4, 0, true, false);
        gd.heightHint = 100;
        this.text.getStyledText().setLayoutData((Object)gd);
        this.text.adaptControls(this.getManagedForm().getToolkit());
        this.submitButton = new Button(composite, 8);
        this.submitButton.setText("Submit");
        this.managedForm.getToolkit().adapt((Control)this.submitButton, true, true);
        this.submitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg = WfeJournalTab.this.text.get();
                if (Strings.isInValid((String)msg)) {
                    AWorkbench.popup((String)"Must enter entry");
                } else {
                    WfeJournalTab.this.submitButton.setEnabled(false);
                    JournalData data = new JournalData();
                    data.setAddMsg(msg);
                    data.setUser(WfeJournalTab.this.atsApi.getUserService().getCurrentUser());
                    WfeJournalTab.this.journalData = WfeJournalTab.this.atsApi.getServerEndpoints().getActionEndpoint().addJournal(WfeJournalTab.this.workItem.getAtsId(), data);
                    if (WfeJournalTab.this.journalData.getResults().isErrors()) {
                        AWorkbench.popup((String)WfeJournalTab.this.journalData.getResults().toString());
                    } else {
                        Set<IAtsWorkItem> workItems = Collections.singleton(WfeJournalTab.this.workItem);
                        WfeJournalTab.this.atsApi.getStoreService().reload(workItems);
                        WfeJournalTab.this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, workItems, WfeJournalTab.this.journalData.getTransaction());
                        WfeJournalTab.this.journalData.setAddMsg("");
                        WfeJournalTab.this.journalData.getResults().clear();
                        WfeJournalTab.this.journalData.setTransaction(TransactionId.SENTINEL);
                    }
                }
                WfeJournalTab.this.text.getStyledText().setFocus();
            }
        });
    }

    private void createBrowser() {
        this.browser = new Browser(this.bodyComp, 0);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.widthHint = 200;
        gd2.heightHint = 300;
        this.browser.setLayoutData((Object)gd2);
    }

    @Override
    public void refresh() {
        if (Widgets.isAccessible((Widget)this.journalComp)) {
            AbstractWorkflowArtifact workItem = this.editor.getWorkItem();
            String msgStr = "No Entries";
            try {
                AtsActionEndpointApi actionUiEp = AtsApiService.get().getServerEndpoints().getActionEndpoint();
                this.journalData = actionUiEp.getJournalData(workItem.getAtsId());
                if (this.journalData != null) {
                    msgStr = this.journalData.getResults().isErrors() ? this.journalData.getResults().toString() : this.journalData.getCurrentMsg();
                }
            }
            catch (Exception ex) {
                msgStr = AHTML.simplePage((String)Lib.exceptionToString((Exception)ex));
            }
            final String fMsgStr = msgStr;
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Widgets.isAccessible((Widget)WfeJournalTab.this.browser)) {
                        WfeJournalTab.this.journalComp.refresh();
                        WfeJournalTab.this.browser.setText(AHTML.textToHtml((String)fMsgStr));
                        WfeJournalTab.this.getManagedForm().reflow(true);
                        WfeJournalTab.this.refreshTabName();
                        WfeJournalTab.this.submitButton.setEnabled(true);
                    }
                }
            });
        }
    }
}

