/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.actions.IDirtyReportable;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.agile.SprintMemberProvider;
import org.eclipse.osee.ats.ide.editor.IWfeEditorListener;
import org.eclipse.osee.ats.ide.editor.WfeInput;
import org.eclipse.osee.ats.ide.editor.event.WfeArtifactEventManager;
import org.eclipse.osee.ats.ide.editor.event.WfeBranchEventManager;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.attributes.WfeAttributesTab;
import org.eclipse.osee.ats.ide.editor.tab.bit.WfeBitTab;
import org.eclipse.osee.ats.ide.editor.tab.defects.WfeDefectsTab;
import org.eclipse.osee.ats.ide.editor.tab.details.WfeDetailsTab;
import org.eclipse.osee.ats.ide.editor.tab.journal.WfeJournalTab;
import org.eclipse.osee.ats.ide.editor.tab.members.WfeMembersTab;
import org.eclipse.osee.ats.ide.editor.tab.metrics.WfeMetricsTab;
import org.eclipse.osee.ats.ide.editor.tab.relations.WfeRelationsTab;
import org.eclipse.osee.ats.ide.editor.tab.reload.WfeReloadTab;
import org.eclipse.osee.ats.ide.editor.tab.task.WfeTasksTab;
import org.eclipse.osee.ats.ide.editor.tab.workflow.WfeWorkFlowTab;
import org.eclipse.osee.ats.ide.editor.tab.workflow.util.WfeOutlinePage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.RecentlyVisitedNavigateItems;
import org.eclipse.osee.ats.ide.util.ServiceUtil;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalMemberProvider;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskComposite;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IAtsMetricsProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.OseeStatusContributionItemFactory;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.AbstractArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.widgets.EditorData;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class WorkflowEditor
extends AbstractArtifactEditor
implements EditorData,
IDirtyReportable,
ISelectedAtsArtifacts,
IAtsMetricsProvider {
    public static final String EDITOR_ID = "org.eclipse.osee.ats.ide.editor.WorkflowEditor";
    private AbstractWorkflowArtifact workItem;
    private WfeWorkFlowTab workFlowTab;
    private WfeMembersTab membersTab;
    private WfeDefectsTab defectsTab;
    private WfeTasksTab taskTab;
    private WfeAttributesTab attrTab;
    private WfeRelationsTab relationsTab;
    private WfeJournalTab journalTab;
    int attrPageIndex = 0;
    private final List<IWfeEditorListener> editorListeners = new ArrayList<IWfeEditorListener>();
    private WfeOutlinePage outlinePage;
    private WfeReloadTab reloadTab;
    private WfeMetricsTab metricsTab;
    private WfeDetailsTab detailsTab;
    private WfeBitTab bitTab;
    private final Collection<WfeAbstractTab> extTabs = new ArrayList<WfeAbstractTab>();

    public void loadPages() {
        this.addPages();
    }

    protected void addPages() {
        WfeInput input;
        block8: {
            input = this.getWfeInput();
            try {
                if (input.getArtifact() == null) break block8;
                if (input.getArtifact() instanceof AbstractWorkflowArtifact) {
                    this.workItem = (AbstractWorkflowArtifact)input.getArtifact();
                    break block8;
                }
                throw new OseeArgumentException("WfeInput artifact must be StateMachineArtifact", new Object[0]);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                return;
            }
        }
        if (!input.isReload() && this.workItem == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Error", (String)"Can't Find Action in DB");
            return;
        }
        try {
            if (input.isReload()) {
                this.createReloadTab();
            } else {
                WfeArtifactEventManager.add(this);
                WfeBranchEventManager.add(this);
                this.createMembersTab();
                this.createWorkflowTab();
                this.createExtensionTabs();
                this.createBitTab();
                this.createAttributesTab();
                this.createRelationsTab();
                this.createTaskTab();
                this.createJournalTab();
                this.createDefectsTab();
                this.createDetailsTab();
            }
            this.updatePartName();
            this.setActivePage(0);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public WfeInput getWfeInput() {
        WfeInput aei = null;
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof WfeInput)) {
            throw new OseeArgumentException("Editor Input not WfeInput", new Object[0]);
        }
        aei = (WfeInput)editorInput;
        return aei;
    }

    public <T> T getAdapter(Class<T> type) {
        if (type != null && type.isAssignableFrom(IContentOutlinePage.class)) {
            WfeOutlinePage page = this.getOutlinePage();
            page.setInput(this);
            return (T)((Object)page);
        }
        return (T)super.getAdapter(type);
    }

    public WfeOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new WfeOutlinePage();
        }
        return this.outlinePage;
    }

    private void createWorkflowTab() {
        try {
            this.workFlowTab = new WfeWorkFlowTab(this, this.workItem);
            this.addPage((IFormPage)this.workFlowTab);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createReloadTab() throws PartInitException {
        this.reloadTab = new WfeReloadTab(this);
        this.addPage((IFormPage)this.reloadTab);
    }

    private void createMembersTab() throws PartInitException {
        if (this.workItem instanceof GoalArtifact) {
            this.membersTab = new WfeMembersTab(this, new GoalMemberProvider((GoalArtifact)this.workItem));
            this.addPage((IFormPage)this.membersTab);
        } else if (this.workItem instanceof SprintArtifact) {
            this.membersTab = new WfeMembersTab(this, new SprintMemberProvider((SprintArtifact)this.workItem));
            this.addPage((IFormPage)this.membersTab);
        }
    }

    private void createTaskTab() throws PartInitException {
        if (this.isTaskable()) {
            this.taskTab = new WfeTasksTab(this, (IAtsTeamWorkflow)this.workItem, AtsApiService.get());
            this.addPage((IFormPage)this.taskTab);
            this.taskTab.refreshTabName();
        }
    }

    private void createJournalTab() throws PartInitException {
        this.journalTab = new WfeJournalTab(this, this.workItem, AtsApiService.get());
        this.addPage((IFormPage)this.journalTab);
    }

    private void createDefectsTab() throws PartInitException {
        if (this.workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview})) {
            this.defectsTab = new WfeDefectsTab(this, (IAtsPeerToPeerReview)this.workItem);
            this.addPage((IFormPage)this.defectsTab);
        }
    }

    private void updatePartName() {
        this.setPartName(this.getTitleStr());
    }

    public String getTitleStr() {
        return this.getWfeInput().getName();
    }

    public void doSave(IProgressMonitor monitor) {
        this.doSave(monitor, null);
    }

    public void doSave(IProgressMonitor monitor, WfeSaveListener saveListener) {
        block7: {
            try {
                if (this.workItem.isHistorical()) {
                    AWorkbench.popup((String)"Historical Error", (String)("You can not change a historical version of " + this.workItem.getArtifactTypeName() + ":\n\n" + (Object)((Object)this.workItem)));
                    break block7;
                }
                if (!this.workItem.isAccessControlWrite()) {
                    AWorkbench.popup((String)"Authentication Error", (String)("You do not have permissions to save " + this.workItem.getArtifactTypeName() + ":" + (Object)((Object)this.workItem)));
                    break block7;
                }
                try {
                    IAtsChangeSet changes = AtsApiService.get().createChangeSet("Workflow Editor - Save");
                    this.workFlowTab.saveXWidgetToArtifact();
                    this.workItem.save(changes);
                    changes.executeIfNeeded();
                    if (saveListener != null) {
                        saveListener.saved(this.workItem, changes);
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                this.getWorkFlowTab().computeSizeAndReflow();
                this.onDirtied();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public void dispose() {
        for (IWfeEditorListener listener : this.editorListeners) {
            listener.editorDisposing();
        }
        WfeArtifactEventManager.remove(this);
        WfeBranchEventManager.remove(this);
        if (this.workItem != null && !this.workItem.isDeleted() && this.workItem.isWfeDirty(new XResultData()).isErrors()) {
            this.workItem.revert();
        }
        if (this.getToolkit() != null) {
            this.getToolkit().dispose();
        }
        super.dispose();
    }

    public void disposeTabs() {
        if (this.metricsTab != null) {
            this.removePage(this.metricsTab.getIndex());
        }
        if (this.attrTab != null) {
            this.removePage(this.attrTab.getIndex());
        }
        if (this.relationsTab != null) {
            this.removePage(this.relationsTab.getIndex());
        }
        if (this.taskTab != null) {
            this.removePage(this.taskTab.getIndex());
        }
        if (this.workFlowTab != null) {
            this.removePage(this.workFlowTab.getIndex());
        }
        for (WfeAbstractTab tab : this.extTabs) {
            this.removePage(tab.getIndex());
        }
        this.extTabs.clear();
        if (this.defectsTab != null) {
            this.removePage(this.defectsTab.getIndex());
        }
        if (this.detailsTab != null) {
            this.removePage(this.detailsTab.getIndex());
        }
        if (this.membersTab != null) {
            this.removePage(this.membersTab.getIndex());
        }
        if (this.journalTab != null) {
            this.removePage(this.journalTab.getIndex());
        }
        if (this.bitTab != null) {
            this.removePage(this.bitTab.getIndex());
        }
        if (this.reloadTab != null) {
            this.removePage(this.reloadTab.getIndex());
            this.reloadTab = null;
        }
    }

    public boolean isDirty() {
        return this.isDirtyResult(new XResultData()).isErrors();
    }

    @Override
    public XResultData isDirtyResult(XResultData rd) {
        if (this.workFlowTab == null || this.getWfeInput().isReload() || this.workItem != null && this.workItem.isDeleted()) {
            return rd;
        }
        try {
            rd.log("===> WorkFlowTab.isXWidgetDirty\n");
            this.workFlowTab.isXWidgetDirty(rd);
            rd.log("\n===> AWA.isWfeDirty\n");
            ((AbstractWorkflowArtifact)((WfeInput)this.getEditorInput()).getArtifact()).isWfeDirty(rd);
            rd.log("\n===> Attribute.isDirty\n");
            for (Attribute attribute : this.workItem.internalGetAttributes()) {
                if (!attribute.isDirty()) continue;
                rd.errorf("Attribute [%s] is dirty\n", new Object[]{attribute.getNameValueDescription()});
            }
            rd.log("\n===> RelationMgr.isDirty\n");
            String rString = RelationManager.reportHasDirtyLinks((Artifact)this.workItem);
            if (Strings.isValid((String)rString)) {
                rd.error("Relation tab is dirty\n");
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            rd.errorf("\n===> WorkflowException.Exception\n[%s]\n", new Object[]{Lib.exceptionToString((Exception)((Object)ex))});
        }
        return rd;
    }

    public String toString() {
        return "WorkflowEditor - " + this.workItem.getAtsId() + " - " + this.workItem.getArtifactTypeName() + " named \"" + this.workItem.getName() + "\"";
    }

    protected void createPages() {
        super.createPages();
        OseeStatusContributionItemFactory.addTo((MultiPageEditorPart)this, (boolean)true);
    }

    private void createExtensionTabs() {
        try {
            for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                for (WfeAbstractTab tab : item.createTabs(this, this.workItem)) {
                    this.addPage((IFormPage)tab);
                    this.extTabs.add(tab);
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createBitTab() {
        try {
            if (this.workItem.isTeamWorkflow()) {
                for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                    WfeBitTab bitTab = item.createBitTab(this, (IAtsTeamWorkflow)this.workItem);
                    if (bitTab == null) continue;
                    this.bitTab = bitTab;
                    this.addPage((IFormPage)bitTab);
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createDetailsTab() {
        try {
            this.detailsTab = new WfeDetailsTab(this, this.workItem);
            this.addPage((IFormPage)this.detailsTab);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createAttributesTab() {
        try {
            if (AtsApiService.get().getUserService().isAtsAdmin()) {
                this.attrTab = new WfeAttributesTab(this, this.workItem);
                this.addPage((IFormPage)this.attrTab);
            }
        }
        catch (PartInitException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createRelationsTab() {
        try {
            if (AtsApiService.get().getUserService().isAtsAdmin()) {
                this.relationsTab = new WfeRelationsTab(this, this.workItem);
                this.addPage((IFormPage)this.relationsTab);
            }
        }
        catch (PartInitException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refresh() {
        try {
            if (this.getContainer() == null || this.getContainer().isDisposed()) {
                return;
            }
            if (this.workFlowTab != null) {
                this.workFlowTab.refresh();
            }
            if (this.attrTab != null) {
                this.attrTab.refresh();
            }
            if (this.relationsTab != null) {
                this.relationsTab.refresh();
            }
            if (this.journalTab != null) {
                this.journalTab.refresh();
            }
            if (this.membersTab != null) {
                this.membersTab.refresh();
            }
            if (this.taskTab != null) {
                this.taskTab.refresh();
            }
            if (this.defectsTab != null) {
                this.defectsTab.refresh();
            }
            if (this.detailsTab != null) {
                this.detailsTab.refresh();
            }
            if (this.bitTab != null) {
                this.bitTab.refresh();
            }
            for (WfeAbstractTab tab : this.extTabs) {
                tab.refresh();
            }
            this.onDirtied();
            this.updatePartName();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public static void editArtifact(Artifact artifact) {
        if (artifact == null) {
            return;
        }
        if (artifact.isDeleted()) {
            AWorkbench.popup((String)"ERROR", (String)"Artifact has been deleted");
            return;
        }
        if (artifact instanceof AbstractWorkflowArtifact) {
            WorkflowEditor.editArtifact((AbstractWorkflowArtifact)artifact);
        } else {
            RendererManager.open((Artifact)artifact, (PresentationType)PresentationType.GENERALIZED_EDIT);
        }
    }

    public static void editArtifact(final AbstractWorkflowArtifact workflow) {
        if (workflow == null) {
            return;
        }
        if (workflow.isDeleted()) {
            AWorkbench.popup((String)"ERROR", (String)"Artifact has been deleted");
            return;
        }
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = AWorkbench.getActivePage();
                try {
                    WorkflowEditor editor = (WorkflowEditor)page.openEditor((IEditorInput)new WfeInput(workflow), WorkflowEditor.EDITOR_ID);
                    if (editor.reloadTab != null) {
                        editor.reloadTab.reloadEditor();
                        RecentlyVisitedNavigateItems.addVisited(workflow);
                    }
                }
                catch (PartInitException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    public void onDirtied() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowEditor.this.firePropertyChange(257);
            }
        });
    }

    public static void close(Set<IAtsTeamWorkflow> singleton, boolean save) {
        WorkflowEditor.close(Collections.castAll(AbstractWorkflowArtifact.class, (Collection)AtsObjects.getArtifacts(singleton)), save);
    }

    public static void close(final Collection<? extends AbstractWorkflowArtifact> artifacts, boolean save) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorReference[] editors = page.getEditorReferences();
                int j = 0;
                while (j < editors.length) {
                    IEditorReference editor = editors[j];
                    if (editor.getPart(false) instanceof WorkflowEditor && artifacts.contains((Object)((WorkflowEditor)editor.getPart(false)).getWorkItem())) {
                        ((WorkflowEditor)editor.getPart(false)).closeEditor();
                    }
                    ++j;
                }
            }
        });
    }

    public static void closeAll() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorReference[] editors = page.getEditorReferences();
                int j = 0;
                while (j < editors.length) {
                    IEditorReference editor = editors[j];
                    if (editor.getPart(false) instanceof WorkflowEditor) {
                        ((WorkflowEditor)editor.getPart(false)).closeEditor();
                    }
                    ++j;
                }
            }
        });
    }

    public static WorkflowEditor getWorkflowEditor(IAtsWorkItem workItem) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editors = page.getEditorReferences();
        int j = 0;
        while (j < editors.length) {
            try {
                IEditorReference editor = editors[j];
                if (editor.getPart(false) instanceof WorkflowEditor) {
                    AbstractWorkflowArtifact editorWorkItem = ((WorkflowEditor)editor.getPart(false)).getWorkItem();
                    if (workItem.equals((Object)editorWorkItem)) {
                        return (WorkflowEditor)editor.getPart(false);
                    }
                    ArtifactId savedArtId = ((WfeInput)editor.getEditorInput()).getSavedArtUuid();
                    if (savedArtId.isValid() && workItem.equals(savedArtId)) {
                        return (WorkflowEditor)editor.getPart(false);
                    }
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)Lib.exceptionToString((Exception)ex));
            }
            ++j;
        }
        return null;
    }

    public static List<WorkflowEditor> getWorkflowEditors() {
        ArrayList<WorkflowEditor> results = new ArrayList<WorkflowEditor>();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editors = page.getEditorReferences();
        int j = 0;
        while (j < editors.length) {
            IEditorReference editor = editors[j];
            if (editor.getPart(false) instanceof WorkflowEditor) {
                results.add((WorkflowEditor)editor.getPart(false));
            }
            ++j;
        }
        return results;
    }

    public void closeEditor() {
        WorkflowEditor editor = this;
        Displays.ensureInDisplayThread((Runnable)new Runnable((MultiPageEditorPart)editor){
            private final /* synthetic */ MultiPageEditorPart val$editor;
            {
                this.val$editor = multiPageEditorPart;
            }

            @Override
            public void run() {
                AWorkbench.getActivePage().closeEditor((IEditorPart)this.val$editor, false);
            }
        });
    }

    public boolean isTaskable() {
        return this.workItem instanceof TeamWorkFlowArtifact;
    }

    public boolean isTasksEditable() {
        boolean editable = true;
        if (!(this.workItem instanceof TeamWorkFlowArtifact) || this.workItem.isCompletedOrCancelled()) {
            editable = false;
        }
        return editable;
    }

    public boolean isAccessControlWrite() {
        return ServiceUtil.getOseeClient().getAccessControlService().hasArtifactPermission((ArtifactToken)this.workItem, PermissionEnum.WRITE, null).isSuccess();
    }

    @Override
    public Collection<? extends Artifact> getMetricsWorkItems() {
        if (this.workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
            return ((GoalArtifact)this.workItem).getMembers();
        }
        return Arrays.asList(this.workItem);
    }

    @Override
    public IAtsVersion getMetricsVersion() {
        return AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)this.workItem);
    }

    @Override
    public double getManHoursPerDayPreference() {
        return this.workItem.getManHrsPerDayPreference();
    }

    public WfeWorkFlowTab getWorkFlowTab() {
        return this.workFlowTab;
    }

    public TaskComposite getTaskComposite() {
        return this.taskTab.getTaskComposite();
    }

    @Override
    public Set<Artifact> getSelectedWorkflowArtifacts() {
        return java.util.Collections.singleton(this.workItem);
    }

    public IEditorPart getActiveEditor() {
        return this;
    }

    public boolean isDisposed() {
        return this.getContainer() == null || this.getContainer().isDisposed();
    }

    public void addEditorListeners(IWfeEditorListener listener) {
        this.editorListeners.add(listener);
    }

    @Override
    public List<Artifact> getSelectedAtsArtifacts() {
        return java.util.Collections.singletonList(this.workItem);
    }

    public Image getTitleImage() {
        Image image = null;
        image = this.getWfeInput().isReload() ? ImageManager.getImage((OseeImage)AtsImage.WORKFLOW) : (this.getWfeInput().isBacklog() ? ImageManager.getImage((KeyedImage)AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_BACKLOG)) : ArtifactImageManager.getImage((Artifact)this.workItem));
        return image;
    }

    public List<Object> getPages() {
        return this.pages;
    }

    protected void pageChange(int newPageIndex) {
        Object page;
        super.pageChange(newPageIndex);
        if (newPageIndex != -1 && this.pages.size() > newPageIndex && (page = this.pages.get(newPageIndex)) != null) {
            Object provider = this.getDefaultSelectionProvider();
            if (page.equals(this.workFlowTab)) {
                provider = this.getDefaultSelectionProvider();
            } else if (page.equals(this.membersTab)) {
                if (this.membersTab != null && this.membersTab.getMembersSection() != null) {
                    provider = this.membersTab.getWorldXViewer();
                }
            } else if (page.equals(this.taskTab)) {
                if (this.taskTab.getTaskComposite() != null) {
                    provider = this.taskTab.getTaskComposite().getWorldXViewer();
                }
            } else {
                String title = this.getPageText(newPageIndex);
                if (title.equalsIgnoreCase("metrics")) {
                    provider = null;
                }
            }
            this.getSite().setSelectionProvider(provider);
        }
    }

    @Override
    public List<TaskArtifact> getSelectedTaskArtifacts() {
        if (this.workItem instanceof TaskArtifact) {
            return Arrays.asList((TaskArtifact)this.workItem);
        }
        return java.util.Collections.emptyList();
    }

    public AbstractWorkflowArtifact getWorkItem() {
        return this.workItem;
    }

    public static void edit(IAtsWorkItem workItem) {
        WorkflowEditor.editArtifact((Artifact)workItem.getStoreObject());
    }

    public static Composite createCommonPageComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public void setTabName(int index, String tabName) {
        this.setPageText(index, tabName);
    }

    public void setPage(int pageId) {
        this.setActivePage(pageId);
    }

    public Button getReloadButton() {
        if (this.reloadTab != null) {
            return this.reloadTab.getReloadButtion();
        }
        return null;
    }

    public String getEditorName() {
        return "Workflow Editor";
    }

    public void openBitTab() {
        if (this.bitTab != null) {
            this.setActivePage(this.bitTab.getIndex());
        }
    }

    public WfeBitTab getBitTab() {
        return this.bitTab;
    }

    public static interface WfeSaveListener {
        public void saved(IAtsWorkItem var1, IAtsChangeSet var2);
    }
}

