/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.copy;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.config.copy.ConfigData;
import org.eclipse.osee.ats.ide.config.copy.CopyAtsConfigurationOperation;
import org.eclipse.osee.ats.ide.config.copy.CopyAtsValidation;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.widgets.XActionableItemCombo;
import org.eclipse.osee.ats.ide.util.widgets.XTeamDefinitionCombo;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CopyAtsConfigurationBlam
extends AbstractBlam {
    private XTeamDefinitionCombo xTeamDefinitionCombo;
    private XActionableItemCombo xActionableItemCombo;

    public String getName() {
        return "Copy ATS Configuration";
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XTeamDefinitionCombo\" displayName=\"Top Team Definition to Copy From (most like new config)\" />");
        builder.append("<XWidget xwidgetType=\"XActionableItemCombo\" displayName=\"Top Actionable Item to Copy From\" />");
        builder.append("<XWidget xwidgetType=\"XText\" displayName=\"Name Search String\" />");
        builder.append("<XWidget xwidgetType=\"XText\" displayName=\"Name Replace String\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Retain Team Leads/Members\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Persist Changes\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    private IAtsTeamDefinition getSelectedTeamDefinition() {
        return (IAtsTeamDefinition)this.xTeamDefinitionCombo.getSelectedTeamDef();
    }

    private IAtsActionableItem getSelectedActionableItem() {
        return this.xActionableItemCombo.getSelectedAi();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        try {
            if (ArtifactCache.getDirtyArtifacts().size() > 0) {
                AWorkbench.popup((String)"Dirty artifacts found in cache, save all artifacts before running this operation (may need to restart)");
                return;
            }
            ConfigData data = new ConfigData();
            data.setSearchStr((String)variableMap.getValue("Name Search String"));
            data.setReplaceStr((String)variableMap.getValue("Name Replace String"));
            data.setTeamDef(this.getSelectedTeamDefinition());
            data.setActionableItem(this.getSelectedActionableItem());
            data.setPersistChanges(variableMap.getBoolean("Persist Changes"));
            data.setRetainTeamLeads(variableMap.getBoolean("Retain Team Leads/Members"));
            XResultData resultData = new XResultData(false);
            new CopyAtsValidation(data, resultData).validate();
            if (resultData.isErrors() || !data.isPersistChanges()) {
                resultData.log("Validation Complete");
                XResultDataUI.report((XResultData)resultData, (String)this.getName());
                return;
            }
            resultData = new XResultData(false);
            CopyAtsConfigurationOperation operation = new CopyAtsConfigurationOperation(data, resultData);
            Jobs.runInJob((AbstractOperation)operation, (boolean)true);
        }
        finally {
            monitor.subTask("Done");
        }
    }

    public String getDescriptionUsage() {
        return "This BLAM will use existing configuration of a top Team Definition to create a new configuration..\nThis includes making team defs, actionable items, setting all team leads/team members and changing name using search string and replace string.";
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals("Top Team Definition to Copy From (most like new config)")) {
            this.xTeamDefinitionCombo = (XTeamDefinitionCombo)xWidget;
        }
        if (xWidget.getLabel().equals("Top Actionable Item to Copy From")) {
            this.xActionableItemCombo = (XActionableItemCombo)xWidget;
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_ADMIN, XNavItemCat.OSEE_ADMIN);
    }
}

