/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.ui.progress.UIJob;

public class AtsConfigOperation
extends AbstractOperation {
    private final String name;
    private String workDefName;
    private final String teamDefName;
    private final Collection<String> versionNames;
    private final Collection<String> actionableItemsNames;
    private IAtsTeamDefinition teamDef;
    private Collection<IAtsActionableItem> actionableItems;
    private WorkDefinition workDefinition = null;

    public AtsConfigOperation(String name, String teamDefName, Collection<String> versionNames, Collection<String> actionableItems) {
        super(name, "org.eclipse.osee.ats.ide");
        this.name = name;
        this.teamDefName = teamDefName;
        this.versionNames = versionNames;
        this.actionableItemsNames = actionableItems;
    }

    public WorkDefinition getWorkDefinition() {
        return this.workDefinition;
    }

    public Collection<IAtsActionableItem> getActionableItems() {
        return this.actionableItems;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        monitor.worked(this.calculateWork(0.1));
        XResultData resultData = new XResultData();
        this.workDefinition = this.createOrGetWorkflowDefinition(resultData);
        if (resultData.isErrors()) {
            throw new OseeStateException("Error created new Work Definition for Team Def %s", new Object[]{this.teamDef.toStringWithId()});
        }
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.name);
        this.teamDef = this.createTeamDefinition(changes, AtsApiService.get());
        AtsApiService.get().getWorkDefinitionService().setWorkDefinitionAttrs(this.teamDef, this.workDefinition, changes);
        this.actionableItems = this.createActionableItems(changes, this.teamDef, AtsApiService.get());
        this.createVersions(changes, this.teamDef);
        changes.execute();
        monitor.worked(this.calculateWork(0.3));
    }

    private IAtsTeamDefinition createTeamDefinition(IAtsChangeSet changes, AtsApi atsApi) {
        TeamDefinition teamDef = AtsApiService.get().getTeamDefinitionService().createTeamDefinition(this.teamDefName, changes);
        changes.relate((Object)AtsApiService.get().getTeamDefinitionService().getTopTeamDefinition(), AtsRelationTypes.TeamMember_Member, (Object)AtsApiService.get().getUserService().getCurrentUser());
        changes.relate((Object)AtsApiService.get().getTeamDefinitionService().getTopTeamDefinition(), AtsRelationTypes.TeamLead_Lead, (Object)AtsApiService.get().getUserService().getCurrentUser());
        changes.relate((Object)AtsApiService.get().getTeamDefinitionService().getTopTeamDefinition(), CoreRelationTypes.DefaultHierarchical_Child, (Object)teamDef);
        atsApi.getConfigService().getConfigurations().addTeamDef(teamDef);
        return teamDef;
    }

    private Collection<IAtsActionableItem> createActionableItems(IAtsChangeSet changes, IAtsTeamDefinition teamDef, AtsApi atsApi) {
        ArrayList<IAtsActionableItem> aias = new ArrayList<IAtsActionableItem>();
        ActionableItem parentAi = AtsApiService.get().getActionableItemService().createActionableItem(this.teamDefName, changes);
        changes.setSoleAttributeValue((IAtsObject)parentAi, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)false);
        parentAi.setActionable(false);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamActionableItem_ActionableItem, (Object)parentAi);
        parentAi.setTeamDefId(teamDef.getId());
        IAtsActionableItem topAi = AtsApiService.get().getActionableItemService().getTopActionableItem(atsApi);
        changes.relate((Object)topAi, CoreRelationTypes.DefaultHierarchical_Child, (Object)parentAi);
        parentAi.setParentId(topAi.getId());
        changes.relate((Object)AtsApiService.get().getActionableItemService().getTopActionableItem((AtsApi)AtsApiService.get()), CoreRelationTypes.DefaultHierarchical_Child, (Object)parentAi);
        atsApi.getConfigService().getConfigurations().addAi(parentAi);
        aias.add((IAtsActionableItem)parentAi);
        for (String name : this.actionableItemsNames) {
            ActionableItem childAi = AtsApiService.get().getActionableItemService().createActionableItem(name, changes);
            changes.setSoleAttributeValue((IAtsObject)childAi, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)true);
            childAi.setActionable(true);
            changes.addChild((ArtifactId)parentAi.getStoreObject(), (ArtifactId)childAi.getStoreObject());
            childAi.setParentId(parentAi.getId());
            aias.add((IAtsActionableItem)childAi);
            atsApi.getConfigService().getConfigurations().addAi(childAi);
        }
        return aias;
    }

    private void createVersions(IAtsChangeSet changes, IAtsTeamDefinition teamDef) {
        if (this.versionNames != null) {
            for (String name : this.versionNames) {
                Version version = AtsApiService.get().getVersionService().createVersion(name, changes);
                AtsApiService.get().getVersionService().setTeamDefinition((IAtsVersion)version, teamDef, changes);
                ((TeamDefinition)teamDef).getVersions().add(version.getId());
                version.setTeamDefId(teamDef.getId());
            }
        }
    }

    private WorkDefinition createOrGetWorkflowDefinition(XResultData resultData) {
        return AtsApiService.get().getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Team_Default);
    }

    public IAtsTeamDefinition getTeamDefinition() {
        return this.teamDef;
    }

    public String getWorkDefName() {
        return this.workDefName;
    }

    public void setWorkDefName(String workDefName) {
        this.workDefName = workDefName;
    }

    public static interface Display {
        public void openAtsConfigurationEditors(IAtsTeamDefinition var1, Collection<IAtsActionableItem> var2, WorkDefinition var3);
    }

    public static final class OpenAtsConfigEditors
    implements Display {
        @Override
        public void openAtsConfigurationEditors(final IAtsTeamDefinition teamDef, final Collection<IAtsActionableItem> aias, final WorkDefinition workDefinition) {
            UIJob job = new UIJob("Open Ats Configuration Editors"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        Artifact teamDefArt = AtsApiService.get().getQueryServiceIde().getArtifact(teamDef);
                        AtsEditors.openATSAction((ArtifactToken)teamDefArt, AtsOpenOption.OpenAll);
                        for (IAtsActionableItem aia : aias) {
                            AtsEditors.openATSAction(AtsApiService.get().getQueryService().getArtifact((IAtsObject)aia), AtsOpenOption.OpenAll);
                        }
                        RendererManager.open((Artifact)ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)AtsArtifactTypes.WorkDefinition, (String)workDefinition.getName(), (BranchId)AtsApiService.get().getAtsBranch()), (PresentationType)PresentationType.SPECIALIZED_EDIT, (IProgressMonitor)monitor);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            };
            Jobs.startJob((Job)job, (boolean)true);
        }
    }
}

