/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column.ev;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnToken;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.WorkPackageFilterTreeDialog;
import org.eclipse.osee.ats.ide.ev.WorkPackageCollectionProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class WorkPackageColumnUI
extends XViewerAtsColumn
implements IMultiColumnEditProvider,
IXViewerValueColumn,
IAltLeftClickProvider {
    public static WorkPackageColumnUI instance = new WorkPackageColumnUI();

    public static WorkPackageColumnUI getInstance() {
        return instance;
    }

    private WorkPackageColumnUI() {
        super(AtsColumnTokens.ActivityIdColumn.getId(), "Work Package (EV)", 80, XViewerAlign.Left, false, SortDataType.String, true, "Provides Work Package dialog from the configured Work Packages related to the selected workflow's Team Definitions.");
    }

    public WorkPackageColumnUI copy() {
        WorkPackageColumnUI newXCol = new WorkPackageColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        String result = "";
        if (element instanceof IAtsObject) {
            result = AtsApiService.get().getColumnService().getColumn((AtsColumnToken)AtsColumnTokens.ActivityIdColumn).getColumnText((IAtsObject)element);
        }
        return result;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        boolean modified = false;
        try {
            if (treeItem.getData() instanceof Artifact) {
                Artifact selectedArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                IAtsTeamWorkflow useTeamWF = null;
                if (selectedArt instanceof IAtsAction && AtsApiService.get().getWorkItemService().getTeams((Object)selectedArt).size() == 1) {
                    useTeamWF = AtsApiService.get().getWorkItemService().getFirstTeam((Object)selectedArt);
                } else if (selectedArt instanceof AbstractWorkflowArtifact) {
                    useTeamWF = (IAtsTeamWorkflow)selectedArt;
                }
                if (useTeamWF != null && (modified = WorkPackageColumnUI.promptChangeActivityId((IAtsWorkItem)useTeamWF, false))) {
                    ((XViewer)((XViewerColumn)treeColumn.getData()).getXViewer()).update((Object)useTeamWF, null);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return modified;
    }

    public static boolean promptChangeActivityId(IAtsWorkItem workItem, boolean persist) {
        return WorkPackageColumnUI.promptChangeActivityIds(Arrays.asList(workItem));
    }

    private static boolean promptChangeActivityIds(Collection<IAtsWorkItem> workItems) {
        boolean modified = false;
        HashSet<IAtsWorkPackage> commonWorkPackageOptions = new HashSet<IAtsWorkPackage>();
        HashSet<IAtsWorkPackage> uniqueWorkPackageOptions = new HashSet<IAtsWorkPackage>();
        Result result = WorkPackageColumnUI.getConfiguredWorkPackageOptions(workItems, commonWorkPackageOptions, uniqueWorkPackageOptions);
        if (result.isFalse()) {
            AWorkbench.popup((String)"Options Invalid", (String)result.getText());
        } else {
            WorkPackageFilterTreeDialog dialog = new WorkPackageFilterTreeDialog("Select Work Package", WorkPackageColumnUI.getMessage(workItems, commonWorkPackageOptions, uniqueWorkPackageOptions), new WorkPackageCollectionProvider(commonWorkPackageOptions));
            dialog.setInput();
            if (dialog.open() == 0) {
                boolean removeFromWorkPackage = dialog.isRemoveFromWorkPackage();
                IAtsWorkPackage workPackage = dialog.getSelection();
                if (removeFromWorkPackage) {
                    AtsApiService.get().getEarnedValueService().removeWorkPackage(workPackage, (Collection)Collections.castAll(workItems));
                } else {
                    AtsApiService.get().getEarnedValueService().setWorkPackage(workPackage, (Collection)Collections.castAll(workItems));
                }
                modified = true;
            }
        }
        return modified;
    }

    private static String getMessage(Collection<IAtsWorkItem> workItems, Set<IAtsWorkPackage> commonWorkPackageOptions, Set<IAtsWorkPackage> uniqueWorkPackageOptions) {
        String message = "Select Work Package";
        if (workItems.size() > 1) {
            message = String.format("Select Work Package Option from %d common option(s) out of %d unique options from selected Work Items", commonWorkPackageOptions.size(), uniqueWorkPackageOptions.size());
        }
        return message;
    }

    private static Result getConfiguredWorkPackageOptions(Collection<IAtsWorkItem> workItems, Set<IAtsWorkPackage> workPackageOptions, Set<IAtsWorkPackage> uniqueWorkPackageOptions) {
        Result result = null;
        for (IAtsWorkItem workItem : workItems) {
            Collection options = AtsApiService.get().getEarnedValueService().getWorkPackageOptions((IAtsObject)workItem);
            uniqueWorkPackageOptions.addAll(options);
            if (options.isEmpty()) {
                result = new Result(false, "One or more selected Work Items had no Work Package Options configured.");
                break;
            }
            if (workPackageOptions.isEmpty()) {
                workPackageOptions.addAll(options);
                continue;
            }
            ArrayList setIntersection = Collections.setIntersection((Collection)options, workPackageOptions);
            workPackageOptions.clear();
            workPackageOptions.addAll(setIntersection);
        }
        if (result == null) {
            result = workPackageOptions.isEmpty() ? new Result(false, "Found no common Work Package Options from selected Work Items.") : Result.TrueResult;
        }
        return result;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof Artifact) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof AbstractWorkflowArtifact)) continue;
                workItems.add((IAtsWorkItem)art);
            }
            if (workItems.isEmpty()) {
                AWorkbench.popup((String)"No Work Items Selected");
            } else {
                WorkPackageColumnUI.promptChangeActivityIds(workItems);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

