/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboWithText;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class OperationalImpactXWidget
extends XComboWithText
implements ArtifactWidget {
    TeamWorkFlowArtifact teamArt;

    public OperationalImpactXWidget() {
        super("Operational Impact", "Operational Impact Description", new String[]{"Yes", "No"}, "Yes", true);
    }

    public Artifact getArtifact() {
        return this.teamArt;
    }

    public void saveToArtifact() {
        String impact = this.get();
        if (impact == null || impact.equals("")) {
            this.teamArt.deleteSoleAttribute((AttributeTypeId)AtsAttributeTypes.OperationalImpact);
        } else {
            this.teamArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpact, impact);
        }
        String desc = this.getDescStr();
        if (desc == null || desc.equals("")) {
            this.teamArt.deleteSoleAttribute((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription);
        } else {
            this.teamArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription, desc);
        }
    }

    public void revert() {
        try {
            super.set((String)this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpact, ""));
            if (this.getText() != null) {
                this.getText().set((String)this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription, ""));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public Result isDirty() {
        if (!this.get().equals(this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpact, ""))) {
            return new Result(true, AtsAttributeTypes.OperationalImpact.toString());
        }
        if (!this.getDescStr().equals(this.teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactDescription, ""))) {
            return new Result(true, AtsAttributeTypes.OperationalImpactDescription.toString());
        }
        return Result.FalseResult;
    }

    private String getDescStr() {
        if (this.getText() == null || !Widgets.isAccessible((Widget)this.getText().getStyledText())) {
            return "";
        }
        return this.getText().get();
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            this.teamArt = (TeamWorkFlowArtifact)artifact;
        }
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        this.revert();
    }

    protected int getTextHeightHint() {
        if (this.getDescStr().equals("")) {
            return 30;
        }
        return super.getTextHeightHint();
    }
}

