/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.OseeClientProperties;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.core.client.server.HttpRequestHandler;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.network.PortUtil;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.CorePreferences;

public class HttpServer {
    protected static final String DEFAULT_SERVICE_NAME = "osee.http.server";
    private static final String LOCALHOST = "localhost";
    private static InternalHttpServer internalHttpServer = null;

    private HttpServer() {
    }

    public static String getServerAddressForExternalCommunication() {
        String serverAddress = "";
        try {
            serverAddress = CorePreferences.getDefaultInetAddress().getHostAddress();
        }
        catch (UnknownHostException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return serverAddress;
    }

    public static String getLocalServerAddress() {
        return LOCALHOST;
    }

    public static int getDefaultServicePort() {
        return internalHttpServer != null ? internalHttpServer.getPort() : -1;
    }

    public static synchronized void startServer(int maxThreads) {
        if (internalHttpServer == null) {
            int portToUse = -1;
            String value = OseeClientProperties.getLocalHttpWorkerPort();
            if (Strings.isValid((String)value)) {
                try {
                    portToUse = Integer.valueOf(value);
                }
                catch (Exception ex) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Unable to parse port property - [%s]", (Object[])new Object[]{value});
                }
            }
            if (portToUse <= 0) {
                try {
                    portToUse = PortUtil.getInstance().getValidPort();
                }
                catch (IOException iOException) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Unable to get a valid port.");
                }
            }
            if (portToUse > 0) {
                internalHttpServer = new InternalHttpServer(DEFAULT_SERVICE_NAME, portToUse, maxThreads);
                Thread thread = new Thread(internalHttpServer);
                thread.setName(String.format("%s:%s", DEFAULT_SERVICE_NAME, portToUse));
                thread.start();
            } else {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Unable to get a valid port for osee http local server.");
            }
        }
    }

    public static void stopServer() {
        if (internalHttpServer != null) {
            internalHttpServer.haltServer();
            if (!HttpServer.internalHttpServer.executorService.isShutdown()) {
                HttpServer.internalHttpServer.executorService.shutdownNow();
            }
        }
    }

    private static final class InternalHttpServer
    implements Runnable {
        private final int port;
        private boolean listenFlag = true;
        private ServerSocket listenSocket;
        private final String serviceName;
        private final ExecutorService executorService;

        private InternalHttpServer(String serviceName, int port, int poolSize) {
            this.serviceName = serviceName;
            this.port = port;
            this.executorService = Executors.newFixedThreadPool(poolSize);
        }

        public void haltServer() {
            this.listenFlag = false;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public int getPort() {
            return this.port;
        }

        private String createNameForConnection(Socket incoming) {
            return String.format("%s:%s - Worker - %s:%s", this.getServiceName(), this.getPort(), incoming.getInetAddress(), incoming.getPort());
        }

        @Override
        public void run() {
            try {
                try {
                    this.listenSocket = new ServerSocket(this.getPort());
                    OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"Starting HttpServer on port: [%s]", (Object[])new Object[]{this.getPort()});
                    while (this.listenFlag) {
                        this.listenSocket.setSoTimeout(10000);
                        try {
                            Socket incoming = this.listenSocket.accept();
                            try {
                                final HttpRequestHandler handler = new HttpRequestHandler(incoming);
                                final String threadName = this.createNameForConnection(incoming);
                                this.executorService.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        Thread thread = Thread.currentThread();
                                        String oldName = thread.getName();
                                        thread.setName(threadName);
                                        try {
                                            handler.run();
                                        }
                                        finally {
                                            thread.setName(oldName);
                                        }
                                    }
                                });
                            }
                            catch (Exception ex) {
                                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error processing request.", (Throwable)ex);
                            }
                        }
                        catch (SocketTimeoutException socketTimeoutException) {}
                    }
                }
                catch (IOException ex) {
                    OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"Unable to start HttpServer, socket may be busy", (Throwable)ex);
                    this.executorService.shutdownNow();
                }
            }
            finally {
                this.executorService.shutdownNow();
            }
        }
    }
}

