/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.session;

import java.util.Date;
import java.util.Properties;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.model.cache.IOseeTypeFactory;
import org.eclipse.osee.framework.core.server.OseeServerProperties;
import org.eclipse.osee.framework.core.server.internal.session.Session;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClientConfig;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;

public final class SessionFactory
implements IOseeTypeFactory {
    private final Log logger;
    private final JdbcService jdbcService;

    public SessionFactory(Log logger, JdbcService jdbcService) {
        this.logger = logger;
        this.jdbcService = jdbcService;
    }

    public Session createLoadedSession(String guid, String userId, Date creationDate, String clientVersion, String clientMachineName, String clientAddress, int clientPort) {
        Session toReturn = this.createNewSession(guid, userId, creationDate, clientVersion, clientMachineName, clientAddress, clientPort);
        return toReturn;
    }

    public Session createNewSession(String guid, String userId, Date creationDate, String clientVersion, String clientMachineName, String clientAddress, int clientPort) {
        Session toReturn = new Session(guid, userId, creationDate, clientVersion, clientMachineName, clientAddress, clientPort);
        return toReturn;
    }

    public OseeSessionGrant createSessionGrant(Session session, UserToken userToken, String authenticationType) {
        Conditions.checkNotNull((Object)session, (String)"Session");
        Conditions.checkNotNull((Object)userToken, (String)"IUserToken");
        JdbcClientConfig config = this.jdbcService.getClient().getConfig();
        OseeSessionGrant sessionGrant = new OseeSessionGrant((String)session.getGuid());
        sessionGrant.setAuthenticationProtocol(authenticationType);
        sessionGrant.setUserToken(userToken);
        sessionGrant.setDbIsProduction(config.isProduction());
        sessionGrant.setDbLogin(config.getDbUsername());
        sessionGrant.setDbId(this.jdbcService.getId());
        sessionGrant.setDbDriver(config.getDbDriver());
        sessionGrant.setDbLogin(config.getDbUsername());
        sessionGrant.setDbUrl(config.getDbUri());
        sessionGrant.setDbConnectionProperties(config.getDbProps());
        sessionGrant.setDbDatabaseName(this.jdbcService.hasServer() ? this.jdbcService.getServerConfig().getDbName() : "");
        sessionGrant.setDbDatabasePath(this.jdbcService.hasServer() ? this.jdbcService.getServerConfig().getDbPath() : "");
        Properties properties = OseeSql.getSqlProperties((boolean)this.jdbcService.getClient().getDbType().areHintsSupported());
        sessionGrant.setSqlProperties(properties);
        sessionGrant.setDataStorePath(OseeServerProperties.getOseeApplicationServerData(this.logger));
        return sessionGrant;
    }
}

