/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.importing;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.CaseInsensitiveString;

public final class RoughAttributeSet
implements Iterable<Map.Entry<CaseInsensitiveString, Collection<RoughAttribute>>> {
    private final Map<CaseInsensitiveString, Collection<RoughAttribute>> attributes = new LinkedHashMap<CaseInsensitiveString, Collection<RoughAttribute>>();

    public void clear() {
        this.attributes.clear();
    }

    public void addAttribute(String name, String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.put(name, new RoughAttribute(value));
            ++n2;
        }
    }

    public void addAttribute(String name, URI ... uris) {
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            this.put(name, new RoughAttribute(uri));
            ++n2;
        }
    }

    public void setAttribute(String type, String value) {
        this.attributes.put(new CaseInsensitiveString(type), Collections.singleton(new RoughAttribute(value)));
    }

    private void put(String name, RoughAttribute attr) {
        CaseInsensitiveString key = new CaseInsensitiveString(name);
        Collection<RoughAttribute> collection = this.attributes.get(key);
        if (collection == null) {
            collection = new LinkedList<RoughAttribute>();
            this.attributes.put(key, collection);
        }
        collection.add(attr);
    }

    public Set<String> getAttributeTypeNames() {
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
        for (CharSequence charSequence : this.attributes.keySet()) {
            typeNames.add(charSequence.toString());
        }
        return typeNames;
    }

    public String getSoleAttributeValue(String typeName) {
        Collection<String> values = this.getAttributeValueList(typeName);
        return values != null && !values.isEmpty() ? values.iterator().next() : null;
    }

    public Collection<String> getAttributeValueList(AttributeTypeToken attributeType) {
        return this.getAttributeValueList(attributeType.getName());
    }

    public Collection<String> getAttributeValueList(AttributeTypeToken attributeType, Collection<String> defaultList) {
        Collection<String> list = this.getAttributeValueList(attributeType);
        return list != null ? list : defaultList;
    }

    public Collection<String> getAttributeValueList(String attributeTypeName) {
        Collection<RoughAttribute> roughAttributes = this.attributes.get(new CaseInsensitiveString(attributeTypeName));
        if (roughAttributes == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (RoughAttribute attribute : roughAttributes) {
            if (attribute.hasURI()) continue;
            values.add(attribute.getValue());
        }
        return values;
    }

    public Collection<URI> getURIAttributes() {
        ArrayList<URI> values = new ArrayList<URI>();
        for (Collection<RoughAttribute> attributeSets : this.attributes.values()) {
            for (RoughAttribute attribute : attributeSets) {
                if (!attribute.hasURI()) continue;
                values.add(attribute.getURI());
            }
        }
        return values;
    }

    @Override
    public Iterator<Map.Entry<CaseInsensitiveString, Collection<RoughAttribute>>> iterator() {
        return this.attributes.entrySet().iterator();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RoughAttributeSet)) {
            return false;
        }
        RoughAttributeSet other = (RoughAttributeSet)obj;
        return this.attributes.equals(other.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public static final class RoughAttribute {
        private final String value;
        private final URI uri;

        public RoughAttribute(String value) {
            this.value = value;
            this.uri = null;
        }

        public RoughAttribute(URI uri) {
            this.value = null;
            this.uri = uri;
        }

        public boolean hasURI() {
            return this.uri != null;
        }

        public InputStream getContent() throws Exception {
            InputStream inputStream = this.hasURI() ? new BufferedInputStream(this.getURI().toURL().openStream()) : new ByteArrayInputStream(this.getValue().getBytes("UTF-8"));
            return inputStream;
        }

        public String getValue() {
            return this.value;
        }

        public URI getURI() {
            return this.uri;
        }

        public String toString() {
            String toReturn = this.hasURI() ? this.getURI().toASCIIString() : this.getValue();
            return toReturn;
        }
    }
}

