/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.PluginUtil;
import org.eclipse.osee.framework.ui.swt.ProgramFinder;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public abstract class OseeUiActivator
extends AbstractUIPlugin {
    private PluginUtil helper;
    private final String pluginId;

    protected OseeUiActivator(String pluginId) {
        this.pluginId = pluginId;
    }

    public File getPluginStoreFile(String path) {
        return this.helper.getPluginStoreFile(path);
    }

    public File getPluginFile(String path) throws IOException {
        return this.helper.getPluginFile(path);
    }

    public InputStream getInputStream(String resource) throws IOException {
        return this.helper.getInputStream(resource);
    }

    public List<URL> getInputStreams(String directory, String pattern, boolean recurse) {
        return this.helper.getInputStreams(directory, pattern, recurse);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.helper = new PluginUtil(this.pluginId);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public Object getBundleHeaderValue(String name) {
        return this.getBundle().getHeaders().get(name);
    }

    public void log(String message) {
        this.getLog().log((IStatus)new Status(0, this.toString(), 0, message, null));
    }

    public void log(String message, Exception ex) {
        this.getLog().log((IStatus)new Status(0, this.toString(), 0, message, (Throwable)ex));
    }

    public static File getBasePluginInstallDirectory() {
        return new File(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + File.separator + "plugins");
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IPath getWorkspaceFile(IPath path) {
        return OseeUiActivator.getWorkspaceRoot().getLocation().append(path);
    }

    public static IPath getWorkspaceFile(String path) {
        return OseeUiActivator.getWorkspaceRoot().getLocation().append(path);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static String getStackMessages(Exception ex) {
        Throwable exloop = ex;
        String exceptionString = "";
        while (exloop != null) {
            exceptionString = String.valueOf(exceptionString) + exloop.getClass().getName() + ":\n\t" + exloop.getMessage() + "\n";
            exloop = exloop.getCause();
        }
        return exceptionString;
    }

    public static Result areOSEEServicesAvailable() {
        Result toReturn = Result.FalseResult;
        StringBuffer message = new StringBuffer();
        message.append("\nCLIENT VERSION: ");
        message.append(OseeCodeVersion.getVersion());
        message.append("\n\n");
        message.append(OseeLog.getStatusReport());
        boolean isStatusOk = OseeLog.isStatusOk();
        toReturn = new Result(isStatusOk, message.toString());
        return toReturn;
    }

    public ImageDescriptor getImageDescriptorForProgram(String extension) {
        Program program;
        ImageDescriptor imageDescriptor = this.getImageRegistry().getDescriptor(extension);
        if (imageDescriptor == null && extension != null && (program = ProgramFinder.findProgram((String)extension)) != null && program.getImageData() != null) {
            imageDescriptor = ImageDescriptor.createFromImageData((ImageData)program.getImageData());
            this.getImageRegistry().put(extension, imageDescriptor);
        }
        return imageDescriptor;
    }
}

