/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.NullOperationLogger;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcTransaction;

public abstract class AbstractDbTxOperation
extends AbstractOperation {
    private final JdbcClient jdbcClient;

    public AbstractDbTxOperation(JdbcClient jdbcClient, String operationName, String pluginId) {
        this(jdbcClient, operationName, pluginId, NullOperationLogger.getSingleton());
    }

    public AbstractDbTxOperation(JdbcClient jdbcClient, String operationName, String pluginId, OperationLogger logger) {
        super(operationName, pluginId, logger);
        this.jdbcClient = jdbcClient;
    }

    protected JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    protected final void doWork(IProgressMonitor monitor) throws Exception {
        this.getJdbcClient().runTransaction((JdbcTransaction)new Transaction(monitor));
    }

    protected abstract void doTxWork(IProgressMonitor var1, JdbcConnection var2);

    protected void handleTxException(IProgressMonitor monitor, Exception ex) {
    }

    protected void handleTxFinally(IProgressMonitor monitor) {
    }

    private final class Transaction
    extends JdbcTransaction {
        private final IProgressMonitor monitor;

        private Transaction(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void handleTxWork(JdbcConnection connection) {
            AbstractDbTxOperation.this.doTxWork(this.monitor, connection);
        }

        public void handleTxException(Exception ex) {
            AbstractDbTxOperation.this.handleTxException(this.monitor, ex);
        }

        public void handleTxFinally() {
            AbstractDbTxOperation.this.handleTxFinally(this.monitor);
        }
    }
}

