/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.topic.event.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationTransfer;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;

public class ArtifactTopicTypeEventFilter
implements ITopicEventFilter {
    private final Collection<ArtifactTypeToken> artifactTypes;

    public ArtifactTopicTypeEventFilter(ArtifactTypeToken ... artifactTypes) {
        this.artifactTypes = Arrays.asList(artifactTypes);
    }

    @Override
    public boolean isMatch(BranchId branch) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isMatchArtifacts(List<? extends EventTopicArtifactTransfer> transferArts) {
        try {
            EventTopicArtifactTransfer transferArt;
            Iterator<? extends EventTopicArtifactTransfer> iterator = transferArts.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.typeMatches((transferArt = iterator.next()).getArtifactTypeId()));
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean isMatchRelationArtifacts(List<? extends EventTopicRelationTransfer> transferRelations) {
        for (EventTopicRelationTransfer eventTopicRelationTransfer : transferRelations) {
            if (!this.typeMatches(eventTopicRelationTransfer.getArtAIdType()) && !this.typeMatches(eventTopicRelationTransfer.getArtBIdType())) continue;
            return true;
        }
        return false;
    }

    private boolean typeMatches(ArtifactTypeId artifactTypeId) {
        ArtifactTypeToken typeToken = ServiceUtil.getOrcsTokenService().getArtifactType(artifactTypeId.getId());
        for (ArtifactTypeToken artifactType : this.artifactTypes) {
            if (typeToken.inheritsFrom((ArtifactTypeId)artifactType)) {
                return true;
            }
            for (ArtifactTypeToken matchArtType : this.artifactTypes) {
                if (!matchArtType.equals(typeToken)) continue;
                return true;
            }
        }
        return false;
    }
}

