/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.linking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.api.publishing.LinkType;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.linking.OseeLinkBuilder;
import org.eclipse.osee.framework.skynet.core.linking.OseeLinkParser;

public class WordMlLinkHandler {
    private static final Matcher OSEE_LINK_PATTERN = Pattern.compile("OSEE_LINK\\((.*?)\\)", 32).matcher("");
    private static final Matcher WORDML_LINK = Pattern.compile("<w:hlink\\s+w:dest=\"(.*?)\"[^>]*?(/>|>.*?</w:hlink\\s*>)", 32).matcher("");
    private static final Matcher HYPERLINK_PATTERN = Pattern.compile("<w:r[^>]*><w:instrText>\\s*HYPERLINK\\s+\"(.+?)\"\\s*</w:instrText></w:r>([^<]</w:t>.+?</w:fldChar></w:r>)?", 32).matcher("");
    private static final OseeLinkBuilder linkBuilder = new OseeLinkBuilder();

    private static LinkType checkLinkType(LinkType value) {
        return value != null ? value : LinkType.OSEE_SERVER_LINK;
    }

    public static String unlink(LinkType sourceLinkType, Artifact source, String content) {
        LinkType linkType = WordMlLinkHandler.checkLinkType(sourceLinkType);
        String modified = content;
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.parseOseeWordMLLinks(content, (HashCollection<String, MatchRange>)new HashCollection());
        if (!matchMap.isEmpty()) {
            modified = WordMlLinkHandler.modifiedContent(linkType, source, content, matchMap, true, null);
        }
        return modified;
    }

    public static String link(LinkType destLinkType, Artifact source, String content, Set<String> unknownGuids) {
        return WordMlLinkHandler.link(destLinkType, source, content, unknownGuids, PresentationType.DEFAULT_OPEN);
    }

    public static String link(LinkType destLinkType, Artifact source, String content, Set<String> unknownGuids, PresentationType presentationType) {
        LinkType linkType = WordMlLinkHandler.checkLinkType(destLinkType);
        String modified = content;
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.getLinks(content, (HashCollection<String, MatchRange>)new HashCollection());
        if (!matchMap.isEmpty()) {
            modified = WordMlLinkHandler.modifiedContent(linkType, source, content, matchMap, false, unknownGuids, presentationType);
            unknownGuids.addAll(matchMap.keySet());
        }
        if (linkType != LinkType.OSEE_SERVER_LINK) {
            modified = String.valueOf(linkBuilder.getWordMlBookmark(source)) + modified;
        }
        return modified;
    }

    public static HashCollection<String, MatchRange> getLinks(String content, HashCollection<String, MatchRange> errorMap) {
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.parseOseeWordMLLinks(content, errorMap);
        OSEE_LINK_PATTERN.reset(content);
        while (OSEE_LINK_PATTERN.find()) {
            String guid = OSEE_LINK_PATTERN.group(1);
            if (Strings.isValid((String)guid)) {
                matchMap.put((Object)guid, (Object)new MatchRange(OSEE_LINK_PATTERN.start(), OSEE_LINK_PATTERN.end()));
                continue;
            }
            errorMap.put((Object)guid, (Object)new MatchRange(WORDML_LINK.start(), WORDML_LINK.end()));
        }
        OSEE_LINK_PATTERN.reset();
        return matchMap;
    }

    private static HashCollection<String, MatchRange> parseOseeWordMLLinks(String content, HashCollection<String, MatchRange> errorMap) {
        String guid;
        String link;
        HashCollection matchMap = new HashCollection();
        OseeLinkParser linkParser = new OseeLinkParser();
        WORDML_LINK.reset(content);
        while (WORDML_LINK.find()) {
            link = WORDML_LINK.group(1);
            if (!Strings.isValid((String)link)) continue;
            linkParser.parse(link);
            guid = linkParser.getGuid();
            if (Strings.isValid((String)guid)) {
                matchMap.put((Object)guid, (Object)new MatchRange(WORDML_LINK.start(), WORDML_LINK.end()));
                continue;
            }
            errorMap.put((Object)linkParser.getErrLink(), (Object)new MatchRange(WORDML_LINK.start(), WORDML_LINK.end()));
        }
        WORDML_LINK.reset();
        HYPERLINK_PATTERN.reset(content);
        while (HYPERLINK_PATTERN.find()) {
            link = HYPERLINK_PATTERN.group(1);
            if (!Strings.isValid((String)link)) continue;
            linkParser.parse(link);
            guid = linkParser.getGuid();
            if (Strings.isValid((String)guid)) {
                matchMap.put((Object)guid, (Object)new MatchRange(HYPERLINK_PATTERN.start(), HYPERLINK_PATTERN.end()));
                continue;
            }
            errorMap.put((Object)linkParser.getErrLink(), (Object)new MatchRange(HYPERLINK_PATTERN.start(), HYPERLINK_PATTERN.end()));
        }
        HYPERLINK_PATTERN.reset();
        return matchMap;
    }

    private static List<Artifact> findArtifacts(TransactionToken transactionId, BranchId branch, boolean isHistorical, List<String> guidsFromLinks) {
        List<Artifact> artifactsFromSearch = isHistorical ? ArtifactQuery.getHistoricalArtifactListFromIds(guidsFromLinks, transactionId, DeletionFlag.INCLUDE_DELETED) : ArtifactQuery.getArtifactListFromIds(guidsFromLinks, branch, DeletionFlag.INCLUDE_DELETED);
        return artifactsFromSearch;
    }

    private static List<String> getGuidsNotFound(List<String> guidsFromLinks, List<Artifact> artifactsFound) {
        HashSet<String> artGuids = new HashSet<String>();
        for (Artifact artifact : artifactsFound) {
            artGuids.add(artifact.getGuid());
        }
        return Collections.setComplement(guidsFromLinks, artGuids);
    }

    private static String modifiedContent(LinkType destLinkType, Artifact source, String original, HashCollection<String, MatchRange> matchMap, boolean isUnliking, Set<String> unknown) {
        return WordMlLinkHandler.modifiedContent(destLinkType, source, original, matchMap, isUnliking, unknown, PresentationType.DEFAULT_OPEN);
    }

    private static String modifiedContent(LinkType destLinkType, Artifact source, String original, HashCollection<String, MatchRange> matchMap, boolean isUnliking, Set<String> unknown, PresentationType presentationType) {
        BranchToken branch = source.getBranch();
        ChangeSet changeSet = new ChangeSet((CharSequence)original);
        Object artifactsFromSearch = null;
        ArrayList<String> guidsFromLinks = new ArrayList<String>(matchMap.keySet());
        artifactsFromSearch = WordMlLinkHandler.findArtifacts(source.getTransaction(), (BranchId)branch, source.isHistorical(), guidsFromLinks);
        if (guidsFromLinks.size() != artifactsFromSearch.size() && BranchManager.getType((BranchId)branch).isMergeBranch()) {
            BranchToken sourceBranch = BranchManager.getParentBranch((BranchId)branch);
            List<String> unknownGuids = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch);
            Iterator<String> union = new ArrayList();
            union.addAll(WordMlLinkHandler.findArtifacts((TransactionToken)BranchManager.getSourceTransaction((BranchId)branch), (BranchId)sourceBranch, source.isHistorical(), unknownGuids));
            union.addAll((Collection<String>)artifactsFromSearch);
            artifactsFromSearch = union;
        }
        if (guidsFromLinks.size() != artifactsFromSearch.size()) {
            List<String> unknownGuids = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch);
            if (isUnliking) {
                for (String guid : unknownGuids) {
                    Collection matches = matchMap.getValues((Object)guid);
                    for (Object match : matches) {
                        String replaceWith = linkBuilder.getOseeLinkMarker(guid);
                        changeSet.replace(((MatchRange)match).start(), ((MatchRange)match).end(), replaceWith);
                    }
                }
            } else if (!unknownGuids.isEmpty()) {
                unknown.addAll(unknownGuids);
                for (String guid : unknownGuids) {
                    for (MatchRange match : (List)matchMap.getValues((Object)guid)) {
                        String link = linkBuilder.getUnknownArtifactLink(guid, (BranchId)branch);
                        changeSet.replace(match.start(), match.end(), link);
                    }
                }
            }
        }
        Iterator<Artifact> iterator = artifactsFromSearch.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = iterator.next();
            for (MatchRange match : (List)matchMap.getValues((Object)artifact.getGuid())) {
                String replaceWith = null;
                replaceWith = isUnliking ? linkBuilder.getOseeLinkMarker(artifact.getGuid()) : linkBuilder.getWordMlLink(destLinkType, artifact, presentationType);
                changeSet.replace(match.start(), match.end(), replaceWith);
            }
        }
        return changeSet.applyChangesToSelf().toString();
    }

    public static final class MatchRange {
        private final int start;
        private final int end;

        public MatchRange(int start, int end) {
            this.end = end;
            this.start = start;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public String toString() {
            return "{" + this.start + ", " + this.end + "}";
        }
    }
}

