/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute.providers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.providers.AbstractAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.DataStore;
import org.eclipse.osee.framework.skynet.core.attribute.providers.ICharacterAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.utils.AttributeResourceProcessor;
import org.eclipse.osee.framework.skynet.core.attribute.utils.BinaryContentUtils;

public class DefaultAttributeDataProvider<T>
extends AbstractAttributeDataProvider<T>
implements ICharacterAttributeDataProvider<T> {
    private T rawValue;
    private final DataStore dataStore;

    public DefaultAttributeDataProvider(Attribute<T> attribute) {
        super(attribute);
        this.dataStore = new DataStore(new AttributeResourceProcessor(attribute));
    }

    @Override
    public String getDisplayableString() {
        return this.getValueAsString();
    }

    @Override
    public void setDisplayableString(String toDisplay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValueAsString() {
        String fromStorage = null;
        byte[] data = null;
        try {
            data = this.dataStore.getContent();
            if (data != null) {
                data = Lib.decompressBytes((InputStream)new ByteArrayInputStream(data));
                fromStorage = new String(data, "UTF-8");
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        if (fromStorage != null) {
            return fromStorage;
        }
        if (this.rawValue != null) {
            return this.rawValue.toString();
        }
        return "";
    }

    @Override
    public boolean setValue(T value) {
        Conditions.checkNotNull(value, (String)"attribute value");
        boolean response = false;
        if (value.equals(this.getValue())) {
            response = false;
        } else {
            this.storeValue(value);
            response = true;
        }
        return response;
    }

    private String getInternalFileName() {
        return BinaryContentUtils.generateFileName(this.getAttribute());
    }

    private void storeValue(T value) {
        if (value != null && value instanceof String && ((String)value).length() > 4000) {
            try {
                byte[] compressed = Lib.compressStream((InputStream)new ByteArrayInputStream(((String)value).getBytes("UTF-8")), (String)this.getInternalFileName());
                this.dataStore.setContent(compressed, "zip", "application/zip", "ISO-8859-1");
                this.rawValue = null;
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        } else {
            this.rawValue = value;
            this.dataStore.clear();
        }
    }

    @Override
    public Object[] getData() {
        return new Object[]{this.getAttribute().convertToStorageString(this.rawValue), this.dataStore.getLocator()};
    }

    @Override
    public void loadData(Object ... objects) {
        if (objects != null && objects.length > 1) {
            if (objects[0] instanceof String) {
                objects[0] = this.getAttribute().convertStringToValue((String)objects[0]);
            }
            this.storeValue(objects[0]);
            this.dataStore.setLocator((String)objects[1]);
        }
    }

    @Override
    public void persist(GammaId storageId) {
        this.dataStore.persist(storageId);
    }

    @Override
    public void purge() {
        this.dataStore.purge();
    }

    @Override
    public Object getValue() {
        return this.rawValue;
    }
}

