/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osee.framework.skynet.core.attribute.CharacterBackedAttribute;

public class DateAttribute
extends CharacterBackedAttribute<Date> {
    public final DateFormat MMDDYYHHMM = new SimpleDateFormat("MM/dd/yyyy hh:mm a");

    public Date getValue() {
        return (Date)this.getAttributeDataProvider().getValue();
    }

    @Override
    public String getDisplayableString() {
        return this.getAsFormattedString(this.MMDDYYHHMM);
    }

    @Override
    public Date convertStringToValue(String value) {
        return new Date(Long.parseLong(value));
    }

    public String getAsFormattedString(DateFormat dateFormat) {
        return dateFormat.format(this.getValue());
    }

    @Override
    public String convertToStorageString(Date rawValue) {
        return String.valueOf(rawValue.getTime());
    }
}

