/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;

public class SearchOptions {
    private final Collection<AttributeTypeId> attributeTypes = new HashSet<AttributeTypeId>();
    private final Collection<ArtifactTypeToken> artifactTypeGuids = new HashSet<ArtifactTypeToken>();
    private DeletionFlag deletionFlag = DeletionFlag.EXCLUDE_DELETED;
    private boolean isMatchWordOrder;
    private boolean isCaseSensive;
    private boolean isSearchAll;
    private boolean isExactMatch;

    public DeletionFlag getDeletionFlag() {
        return this.deletionFlag;
    }

    public boolean isMatchWordOrder() {
        return this.isMatchWordOrder;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensive;
    }

    public boolean isSearchAll() {
        return this.isSearchAll;
    }

    public boolean isExactMatch() {
        return this.isExactMatch;
    }

    public Collection<AttributeTypeId> getAttributeTypeFilter() {
        return this.attributeTypes;
    }

    public void setAttributeTypeFilter(AttributeTypeId[] typeFilter) {
        this.attributeTypes.addAll(Arrays.asList(typeFilter));
    }

    public void clearTypeFilter() {
        this.attributeTypes.clear();
    }

    public void addAttributeTypeFilter(AttributeTypeId type) {
        this.attributeTypes.add(type);
    }

    public void setDeletedIncluded(DeletionFlag deletionFlag) {
        this.deletionFlag = deletionFlag;
    }

    public void setMatchWordOrder(boolean isMatchWordOrder) {
        this.isMatchWordOrder = isMatchWordOrder;
    }

    public void setCaseSensive(boolean isCaseSensive) {
        this.isCaseSensive = isCaseSensive;
    }

    public void setIsSearchAll(boolean isSearchAll) {
        this.isSearchAll = isSearchAll;
    }

    public void setExactMatch(boolean exactMatchEnabled) {
        this.isExactMatch = exactMatchEnabled;
    }

    public String toString() {
        return "SearchOptions [attributeTypeGuids=" + this.attributeTypes + ", artifactTypeGuids=" + this.artifactTypeGuids + ", isIncludeDeleted=" + this.getDeletionFlag() + ", isMatchWordOrder=" + this.isMatchWordOrder + ", isCaseSensive=" + this.isCaseSensive + ", isExactMatch=" + this.isExactMatch + "]";
    }

    public void setArtifactTypeFilter(ArtifactTypeToken[] artifactTypeFilter) {
        ArtifactTypeToken[] artifactTypeTokenArray = artifactTypeFilter;
        int n = artifactTypeFilter.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeToken type = artifactTypeTokenArray[n2];
            this.artifactTypeGuids.add(type);
            ++n2;
        }
    }

    public Collection<ArtifactTypeToken> getArtifactTypeFilter() {
        return this.artifactTypeGuids;
    }
}

