/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.SkipAtsConfigJsonWriter;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.WorkItemWriterOptions;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;

@Provider
public class ConfigJsonWriter
implements MessageBodyWriter<IAtsConfigObject> {
    private JsonFactory jsonFactory;
    private AtsApi atsApiServer;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setAtsApiServer(AtsApiServer atsApiServer) {
        this.atsApiServer = atsApiServer;
    }

    public void start() {
        this.jsonFactory = JsonUtil.getFactory();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(IAtsConfigObject data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (JsonUtil.hasAnnotation(SkipAtsConfigJsonWriter.class, (Annotation[])annotations)) {
            return false;
        }
        boolean assignableFrom = IAtsConfigObject.class.isAssignableFrom(type);
        return assignableFrom && MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    public void writeTo(IAtsConfigObject config, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        try {
            writer = this.jsonFactory.createGenerator(entityStream);
            writer.writeStartArray();
            ConfigJsonWriter.addProgramObject(this.atsApiServer, this.orcsApi, (IAtsObject)config, annotations, writer, JsonUtil.hasAnnotation(IdentityView.class, (Annotation[])annotations));
            writer.writeEndArray();
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    public static void addProgramObject(AtsApi atsApi, OrcsApi orcsApi, IAtsObject atsObject, Annotation[] annotations, JsonGenerator writer, boolean identityView) throws IOException, JsonGenerationException, JsonProcessingException {
        ArtifactReadable artifact = (ArtifactReadable)atsApi.getQueryService().getArtifact(atsObject);
        writer.writeStartObject();
        writer.writeNumberField("id", atsObject.getId().longValue());
        writer.writeStringField("name", atsObject.getName());
        writer.writeStringField("Description", atsObject.getDescription());
        if (atsObject instanceof IAtsTeamDefinition && !identityView) {
            writer.writeArrayFieldStart("version");
            for (ArtifactReadable verArt : artifact.getRelated(AtsRelationTypes.TeamDefinitionToVersion_Version)) {
                Version version = atsApi.getVersionService().getVersionById((ArtifactId)verArt);
                ConfigJsonWriter.addProgramObject(atsApi, orcsApi, (IAtsObject)version, annotations, writer, true);
            }
            writer.writeEndArray();
        }
        if (atsObject instanceof IAtsVersion) {
            if (!identityView) {
                writer.writeArrayFieldStart("workflow");
                for (ArtifactReadable workArt : artifact.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, workArt);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsInsertionActivity) {
            IAtsInsertionActivity activity = (IAtsInsertionActivity)atsObject;
            writer.writeBooleanField("Active", activity.isActive());
            if (!identityView) {
                writer.writeArrayFieldStart("insertion");
                for (ArtifactReadable insertion : artifact.getRelated(AtsRelationTypes.InsertionToInsertionActivity_Insertion)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, insertion);
                }
                writer.writeEndArray();
                writer.writeArrayFieldStart("workpackage");
                for (ArtifactReadable workPackage : artifact.getRelated(AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, workPackage);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsInsertion) {
            IAtsInsertion insertion = (IAtsInsertion)atsObject;
            writer.writeBooleanField("Active", insertion.isActive());
            if (!identityView) {
                writer.writeArrayFieldStart("program");
                for (ArtifactReadable program : artifact.getRelated(AtsRelationTypes.ProgramToInsertion_Program)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, program);
                }
                writer.writeEndArray();
                writer.writeArrayFieldStart("insertionactivity");
                for (ArtifactReadable activity : artifact.getRelated(AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, activity);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsProgram) {
            IAtsProgram program = (IAtsProgram)atsObject;
            writer.writeStringField("Namespace", atsApi.getProgramService().getNamespace(program));
            writer.writeBooleanField("Active", program.isActive());
            if (!identityView) {
                writer.writeArrayFieldStart("country");
                for (ArtifactReadable country : artifact.getRelated(AtsRelationTypes.CountryToProgram_Country)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, country);
                }
                writer.writeEndArray();
                writer.writeArrayFieldStart("insertion");
                for (ArtifactReadable insertion : artifact.getRelated(AtsRelationTypes.ProgramToInsertion_Insertion)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, insertion);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsCountry) {
            IAtsCountry country = (IAtsCountry)atsObject;
            if (!identityView) {
                writer.writeArrayFieldStart("programs");
                List programs = atsApi.getProgramService().getPrograms(country);
                for (IAtsProgram program : programs) {
                    writer.writeStartObject();
                    writer.writeNumberField("id", program.getId().longValue());
                    writer.writeStringField("name", program.getName());
                    writer.writeBooleanField("active", program.isActive());
                    writer.writeEndObject();
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAgileTeam) {
            IAgileTeam team = (IAgileTeam)atsObject;
            writer.writeBooleanField("Active", team.isActive());
            writer.writeStringField("Description", team.getDescription());
            writer.writeArrayFieldStart("featureGroups");
            Collection featureGroups = atsApi.getAgileService().getAgileFeatureGroups(team);
            for (IAgileFeatureGroup group : featureGroups) {
                writer.writeStartObject();
                writer.writeNumberField("id", group.getId().longValue());
                writer.writeStringField("name", group.getName());
                writer.writeBooleanField("active", group.isActive());
                writer.writeEndObject();
            }
            writer.writeEndArray();
            writer.writeArrayFieldStart("syncSprints");
            Collection agileSprints = atsApi.getAgileService().getAgileSprints(team);
            for (IAgileSprint sprint : agileSprints) {
                writer.writeStartObject();
                writer.writeNumberField("id", sprint.getId().longValue());
                writer.writeStringField("name", sprint.getName());
                writer.writeBooleanField("active", sprint.isActive());
                writer.writeEndObject();
            }
            writer.writeEndArray();
            ArtifactReadable teamArt = (ArtifactReadable)atsApi.getQueryService().getArtifact((IAtsObject)team);
            ArtifactReadable backlogArt = (ArtifactReadable)teamArt.getRelated(AtsRelationTypes.AgileTeamToBacklog_Backlog).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            writer.writeStringField("Backlog Id", backlogArt.isValid() ? backlogArt.getIdString() : "");
            writer.writeStringField("Backlog", backlogArt.isValid() ? backlogArt.getName() : "");
        }
        if (!identityView) {
            ConfigJsonWriter.addAttributeData(writer, artifact, Collections.emptyList(), atsApi, orcsApi);
        }
        writer.writeEndObject();
    }

    public static void addAttributeData(JsonGenerator writer, ArtifactReadable artifact, List<WorkItemWriterOptions> options, AtsApi atsApi, OrcsApi orcsApi) throws IOException, JsonGenerationException, JsonProcessingException {
        Collection<AttributeTypeToken> attrTypes = ConfigJsonWriter.getAttributeTypes(artifact);
        ResultSet attributes = artifact.getAttributes();
        boolean fieldsAsIds = options.contains(WorkItemWriterOptions.KeysAsIds);
        boolean datesAsLong = options.contains(WorkItemWriterOptions.DatesAsLong);
        if (!attributes.isEmpty()) {
            for (AttributeTypeToken attrType : attrTypes) {
                if (attrType.getName().contains("Mising Attribute Type ")) {
                    writer.writeFieldName("Invalid Type");
                    writer.writeString(attrType.getName());
                    continue;
                }
                boolean isDateType = attrType.isDate();
                List attributeValues = artifact.getAttributeValues(attrType);
                if (attributeValues.isEmpty()) continue;
                if (attributeValues.size() > 1) {
                    if (fieldsAsIds) {
                        writer.writeArrayFieldStart(attrType.getIdString());
                    } else {
                        writer.writeArrayFieldStart(attrType.getName());
                    }
                    for (Object value : attributeValues) {
                        ConfigJsonWriter.writeObjectValue(writer, datesAsLong, isDateType, value);
                    }
                    writer.writeEndArray();
                    continue;
                }
                if (attributeValues.size() != 1) continue;
                String field = fieldsAsIds ? attrType.getIdString() : attrType.getName();
                writer.writeFieldName(field);
                Object value = attributeValues.iterator().next();
                ConfigJsonWriter.writeObjectValue(writer, datesAsLong, isDateType, value);
            }
        }
    }

    private static Collection<AttributeTypeToken> getAttributeTypes(ArtifactReadable artifact) {
        HashSet<AttributeTypeToken> types = new HashSet<AttributeTypeToken>();
        for (AttributeReadable attr : artifact.getAttributes()) {
            types.add(attr.getAttributeType());
        }
        return types;
    }

    public static void addAttributeDataWithIds(JsonGenerator writer, ArtifactReadable artifact, List<WorkItemWriterOptions> options, AtsApi atsApi, OrcsApi orcsApi) throws IOException, JsonGenerationException, JsonProcessingException {
        ResultSet attributes = artifact.getAttributes();
        boolean keysAsIds = options.contains(WorkItemWriterOptions.KeysAsIds);
        boolean datesAsLong = options.contains(WorkItemWriterOptions.DatesAsLong);
        if (!attributes.isEmpty()) {
            LinkedList<Long> writtenTypes = new LinkedList<Long>();
            HashCollection<String, AttributeReadable<Object>> attrIdToAttrsMap = ConfigJsonWriter.getAttributeMap((ResultSet<? extends AttributeReadable<Object>>)attributes);
            for (String attrId : attrIdToAttrsMap.keySet()) {
                AttributeReadable attr2;
                List attributeValues = (List)attrIdToAttrsMap.getValues((Object)attrId);
                AttributeTypeToken attrType = ((AttributeReadable)attributeValues.iterator().next()).getAttributeType();
                if (writtenTypes.contains(attrType.getId())) continue;
                writtenTypes.add(attrType.getId());
                boolean isDateType = attrType.isDate();
                if (attributeValues.size() > 1) {
                    if (keysAsIds) {
                        writer.writeArrayFieldStart(attrType.getIdString());
                    } else {
                        writer.writeArrayFieldStart(attrType.getName());
                    }
                    for (AttributeReadable attr2 : attributeValues) {
                        writer.writeStartObject();
                        ConfigJsonWriter.writeObjectValueField(writer, datesAsLong, isDateType, attr2.getDisplayableString());
                        writer.writeNumberField("attrId", attr2.getId().longValue());
                        writer.writeNumberField("gammaId", attr2.getGammaId().getId().longValue());
                        writer.writeEndObject();
                    }
                    writer.writeEndArray();
                    continue;
                }
                if (attributeValues.size() != 1) continue;
                attr2 = (AttributeReadable)attributeValues.iterator().next();
                if (keysAsIds) {
                    writer.writeObjectFieldStart(attrType.getIdString());
                } else {
                    writer.writeObjectFieldStart(attrType.getName());
                }
                ConfigJsonWriter.writeObjectValueField(writer, datesAsLong, isDateType, attr2.getValue());
                writer.writeNumberField("attrId", attr2.getId().longValue());
                writer.writeNumberField("gammaId", attr2.getGammaId().getId().longValue());
                writer.writeEndObject();
            }
        }
    }

    private static HashCollection<String, AttributeReadable<Object>> getAttributeMap(ResultSet<? extends AttributeReadable<Object>> attributes) {
        HashCollection attrIdToAttrsMap = new HashCollection();
        for (AttributeReadable attr : attributes) {
            attrIdToAttrsMap.put((Object)attr.getAttributeType().getIdString(), (Object)attr);
        }
        return attrIdToAttrsMap;
    }

    private static void writeObjectValue(JsonGenerator writer, boolean datesAsLong, boolean isDateType, Object value) throws IOException, JsonGenerationException, JsonProcessingException {
        if (isDateType) {
            if (datesAsLong) {
                writer.writeString(String.valueOf(((Date)value).getTime()));
            } else {
                writer.writeString(DateUtil.getMMDDYY((Date)((Date)value)));
            }
        } else {
            writer.writeObject(value);
        }
    }

    private static void writeObjectValueField(JsonGenerator writer, boolean datesAsLong, boolean isDateType, Object value) throws IOException, JsonGenerationException, JsonProcessingException {
        if (isDateType) {
            if (datesAsLong) {
                writer.writeStringField("value", String.valueOf(((Date)value).getTime()));
            } else {
                writer.writeStringField("value", DateUtil.getMMDDYY((Date)((Date)value)));
            }
        } else {
            writer.writeObjectField("value", value);
        }
    }

    private static void addArtifactIdentity(JsonGenerator writer, ArtifactReadable workArt) throws IOException, JsonGenerationException, JsonProcessingException {
        writer.writeStartObject();
        writer.writeNumberField("id", workArt.getId().longValue());
        writer.writeStringField("name", workArt.getName());
        writer.writeEndObject();
    }
}

