/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraAttributeDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraBranchDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraRelationDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraTxDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectField;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlFieldResolver;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerComparator;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class OrcsScriptSqlWriter
extends AbstractSqlWriter {
    private final HashMap<SqlTable, String> mainAliases = new HashMap();
    private static final SqlHandlerComparator HANDLER_COMPARATOR = new SqlHandlerComparator();
    private final SqlFieldResolver fieldResolver;

    public OrcsScriptSqlWriter(SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context, QueryData queryData) {
        super(joinFactory, jdbcClient, context, queryData);
        this.fieldResolver = new SqlFieldResolver(this.getAliasManager(), queryData.getSelectSets());
    }

    @Override
    public void build(List<SqlHandler<?>> handlers) {
        super.build(handlers);
        this.getContext().setObjectDescription(this.fieldResolver.getResult());
    }

    @Override
    protected void write(Iterable<SqlHandler<?>> handlers) {
        List<SqlHandler<?>> xtraHandlers;
        this.fieldResolver.reset();
        this.computeTxFilterClause(handlers);
        this.computeTables(handlers);
        this.fieldResolver.resolve();
        this.writeWithClause(handlers);
        if (this.fieldResolver.hasUnresolvedFields()) {
            xtraHandlers = this.getFieldResolvers(this.fieldResolver.getUnresolved());
            this.computeTables(xtraHandlers);
            this.fieldResolver.resolve();
        } else {
            xtraHandlers = Collections.emptyList();
        }
        this.writeSelect(handlers);
        this.write("\n FROM \n");
        this.writeTables();
        this.write("\n WHERE ");
        this.writePredicates(Iterables.concat(handlers, xtraHandlers));
        this.removeDanglingSeparator("\n WHERE \n");
        this.writeGroupAndOrder(handlers);
    }

    @Override
    protected void writeSelectFields() {
        this.writeCommaIfNotFirst();
        MutableBoolean isFirst = new MutableBoolean(true);
        for (DynamicData data : this.fieldResolver.getResult().getDynamicData()) {
            this.writeSelects(data, isFirst);
        }
    }

    private void writeSelects(DynamicData data, MutableBoolean isFirst) {
        if (data instanceof DynamicObject) {
            DynamicObject object = (DynamicObject)data;
            for (DynamicData child : object.getChildren()) {
                this.writeSelects(child, isFirst);
            }
        } else {
            Map<String, String> columnInfo = SqlFieldResolver.getColumnInfo(data);
            for (Map.Entry<String, String> entry : columnInfo.entrySet()) {
                if (!isFirst.getValue()) {
                    this.write(", ");
                } else {
                    isFirst.setValue(false);
                }
                String columnUuid = entry.getKey();
                String qualifiedColumn = entry.getValue();
                this.write(qualifiedColumn);
                this.write(" as ");
                this.write(columnUuid);
            }
        }
    }

    @Override
    public void writeGroupAndOrder(Iterable<SqlHandler<?>> handlers) {
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            throw new UnsupportedOperationException("Historical dynamic query not supported");
        }
        if (!this.rootQueryData.isCountQueryType()) {
            boolean isFirst = true;
            for (String value : this.fieldResolver.getSortFields()) {
                if (isFirst) {
                    isFirst = false;
                    this.write("\n ORDER BY ");
                } else {
                    this.write(", ");
                }
                this.write(value);
            }
        }
    }

    @Override
    public void writeTxBranchFilter(String txsAlias, boolean allowDeleted) {
        this.writeTxFilter(txsAlias, allowDeleted);
        if (this.hasAlias(OseeDb.BRANCH_TABLE)) {
            String alias = this.getFirstAlias(OseeDb.BRANCH_TABLE);
            this.writeAnd();
            this.write(txsAlias);
            this.write(".branch_id = ");
            this.write(alias);
            this.write(".branch_id");
        } else if (this.hasAlias(OseeDb.TX_DETAILS_TABLE)) {
            String alias = this.getFirstAlias(OseeDb.TX_DETAILS_TABLE);
            this.writeAnd();
            this.write(txsAlias);
            this.write(".transaction_id = ");
            this.write(alias);
            this.write(".transaction_id");
            this.writeAnd();
            this.write(txsAlias);
            this.write(".branch_id = ");
            this.write(alias);
            this.write(".branch_id");
        }
    }

    private void computeTxFilterClause(Iterable<SqlHandler<?>> handlers) {
        ArrayList branchHandlers = new ArrayList();
        ArrayList txHandlers = new ArrayList();
        ArrayList artHandlers = new ArrayList();
        for (SqlHandler<?> handler : handlers) {
            if (handler.getPriority() <= SqlHandlerPriority.ALL_BRANCHES.ordinal()) {
                branchHandlers.add(handler);
                continue;
            }
            if (handler.getPriority() <= SqlHandlerPriority.TX_LAST.ordinal()) {
                txHandlers.add(handler);
                continue;
            }
            artHandlers.add(handler);
        }
        if (!artHandlers.isEmpty()) {
            SqlTable table = null;
            ArrayList withQueryHandlers = null;
            if (!branchHandlers.isEmpty()) {
                withQueryHandlers = branchHandlers;
                table = OseeDb.BRANCH_TABLE;
            } else if (!txHandlers.isEmpty()) {
                withQueryHandlers = txHandlers;
                table = OseeDb.TX_DETAILS_TABLE;
            }
            if (withQueryHandlers != null && table != null) {
                this.computeTables(withQueryHandlers);
                this.writeWithClause(withQueryHandlers);
                this.write("\n FROM \n");
                this.writeTables();
                this.write("\n WHERE ");
                this.writePredicates(withQueryHandlers);
                String tbAlias = this.getFirstAlias(table);
                StringBuilder withBuilder = new StringBuilder();
                withBuilder.append("SELECT DISTINCT ");
                withBuilder.append(tbAlias);
                withBuilder.append(".branch_id ");
                withBuilder.append(this.toString());
                SqlContext context = this.getContext();
                withBuilder.toString().replaceAll("\\s+", " ");
                Lists.newArrayList(context.getJoins());
                Lists.newArrayList(context.getParameters());
                this.reset();
                this.mainAliases.clear();
            }
        }
    }

    private List<SqlHandler<?>> getFieldResolvers(Iterable<DynamicData> datas) {
        ArrayList toReturn = new ArrayList();
        HashSet<String> created = new HashSet<String>();
        for (DynamicData data : datas) {
            SqlHandler<?> handler;
            ObjectType type;
            ObjectField objectField;
            SqlTable table;
            int level = data.getLevel();
            String key = this.asKey(level, table = (objectField = SqlFieldResolver.getObjectField(data)).getTable(), type = objectField.getType());
            if (created.contains(key) || (handler = this.newSqlHandler(level, table, type)) == null) continue;
            created.add(key);
            toReturn.add(handler);
        }
        Collections.sort(toReturn, HANDLER_COMPARATOR);
        return toReturn;
    }

    private String asKey(int level, SqlTable table, ObjectType type) {
        return String.format("%s.%s.%s", level, table, type);
    }

    private SqlHandler<?> newSqlHandler(int level, SqlTable table, ObjectType type) {
        SqlHandler handler = null;
        SqlHandlerPriority priority = this.getXtraSqlHandlerPriority(table, type);
        switch (table.getName()) {
            case "osee_tx_details": {
                handler = new XtraTxDataSqlHandler(priority, type);
                break;
            }
            case "osee_branch": {
                handler = new XtraBranchDataSqlHandler(priority, type);
                break;
            }
            case "osee_attribute": {
                handler = new XtraAttributeDataSqlHandler();
                break;
            }
            case "osee_relation_link": {
                handler = new XtraRelationDataSqlHandler();
                break;
            }
        }
        if (handler != null) {
            handler.setLevel(level);
        }
        return handler;
    }

    private SqlHandlerPriority getXtraSqlHandlerPriority(SqlTable table, ObjectType type) {
        SqlHandlerPriority priority = SqlHandlerPriority.LAST;
        if (type != null) {
            switch (type) {
                case ARTIFACT: {
                    priority = SqlHandlerPriority.ARTIFACT_TX_DATA_XTRA;
                    break;
                }
                case ATTRIBUTE: {
                    priority = SqlHandlerPriority.ATTRIBUTE_TX_DATA_XTRA;
                    break;
                }
                case RELATION: {
                    priority = SqlHandlerPriority.RELATION_TX_DATA_XTRA;
                    break;
                }
                case BRANCH: {
                    priority = SqlHandlerPriority.BRANCH_TX_DATA_XTRA;
                    break;
                }
            }
        }
        return priority;
    }

    @Override
    public String getMainTableAlias(SqlTable table) {
        String alias = this.mainAliases.get(table);
        if (alias == null) {
            alias = this.addTable(table);
            this.mainAliases.put(table, alias);
        }
        return alias;
    }

    @Override
    protected boolean mainTableAliasExists(SqlTable table) {
        return this.mainAliases.containsKey(table);
    }
}

