/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.callable;

import java.util.ArrayList;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;

public final class DeleteTagSetDatabaseTxCallable
extends AbstractDatastoreTxCallable<Integer> {
    private static final String DELETE_SEARCH_TAGS = "delete from osee_search_tags where gamma_id = ?";
    private static final String SELECT_GAMMAS_FROM_TX_JOIN = "select gamma_id from osee_join_transaction where query_id = ?";
    private final int queryId;

    public DeleteTagSetDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, int queryId) {
        super(logger, session, jdbcClient);
        this.queryId = queryId;
    }

    @Override
    protected Integer handleTxWork(JdbcConnection connection) {
        int numberDeleted = 0;
        try (JdbcStatement chStmt = this.getJdbcClient().getStatement(connection);){
            chStmt.runPreparedQuery(SELECT_GAMMAS_FROM_TX_JOIN, new Object[]{this.queryId});
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            while (chStmt.next()) {
                datas.add(new Object[]{chStmt.getLong("gamma_id")});
            }
            if (!datas.isEmpty()) {
                numberDeleted = this.getJdbcClient().runBatchUpdate(connection, DELETE_SEARCH_TAGS, datas);
            }
        }
        return numberDeleted;
    }
}

