/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorProvider;
import org.eclipse.osee.ats.ide.world.search.NextVersionSearchItem;
import org.eclipse.osee.ats.ide.world.search.VersionTargetedForTeamSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;

public class WorldEditorUISearchItemProvider
extends WorldEditorProvider {
    private final WorldUISearchItem worldUISearchItem;

    public WorldEditorUISearchItemProvider(WorldUISearchItem worldUISearchItem, CustomizeData customizeData, XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        super(customizeData, tableLoadOptions);
        this.worldUISearchItem = worldUISearchItem;
    }

    @Override
    public IWorldEditorProvider copyProvider() {
        return new WorldEditorUISearchItemProvider((WorldUISearchItem)this.worldUISearchItem.copy(), this.customizeData, this.tableLoadOptions);
    }

    @Override
    public String getName() {
        return this.worldUISearchItem.getName();
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return Strings.truncate((String)this.worldUISearchItem.getSelectedName(searchType), (int)80, (boolean)true);
    }

    @Override
    public void run(WorldEditor worldEditor, WorldSearchItem.SearchType searchType, boolean forcePend) {
        List<XNavigateComposite.TableLoadOption> options = Arrays.asList(this.tableLoadOptions);
        if (!options.contains(XNavigateComposite.TableLoadOption.NoUI) && searchType == WorldSearchItem.SearchType.Search) {
            this.worldUISearchItem.performUI(searchType);
        }
        if (this.worldUISearchItem.isCancelled()) {
            worldEditor.close(false);
            return;
        }
        boolean pend = options.contains(XNavigateComposite.TableLoadOption.ForcePend) || forcePend;
        super.run(worldEditor, searchType, pend);
    }

    @Override
    public IAtsVersion getTargetedVersionArtifact() {
        if (this.worldUISearchItem instanceof VersionTargetedForTeamSearchItem) {
            return ((VersionTargetedForTeamSearchItem)this.worldUISearchItem).getSearchVersionArtifact();
        }
        if (this.worldUISearchItem instanceof NextVersionSearchItem) {
            return ((NextVersionSearchItem)this.worldUISearchItem).getSelectedVersionArt();
        }
        return null;
    }

    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        return this.worldUISearchItem.performSearchGetResults(false, searchType);
    }
}

