/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.help.ui.AtsHelpContext;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditorProvider;
import org.eclipse.osee.ats.ide.world.AtsMetricsComposite;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsMetricsProvider;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.ats.ide.world.IWorldEditor;
import org.eclipse.osee.ats.ide.world.IWorldEditorConsumer;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldEditorInput;
import org.eclipse.osee.ats.ide.world.WorldEditorReloadProvider;
import org.eclipse.osee.ats.ide.world.WorldReloadTab;
import org.eclipse.osee.ats.ide.world.WorldXWidgetActionPage;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.skynet.OseeStatusContributionItemFactory;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorPart;

public class WorldEditor
extends FormEditor
implements IWorldEditor,
IDirtiableEditor,
IAtsMetricsProvider {
    public static final String EDITOR_ID = "org.eclipse.osee.ats.ide.world.WorldEditor";
    protected WorldXWidgetActionPage worldXWidgetActionPage;
    public static final int TITLE_MAX_LENGTH = 80;

    public void doSave(IProgressMonitor monitor) {
    }

    public static void open(final IWorldEditorProvider provider) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = AWorkbench.getActivePage();
                try {
                    page.openEditor((IEditorInput)new WorldEditorInput(provider), WorldEditor.EDITOR_ID);
                }
                catch (PartInitException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    public static Collection<WorldEditor> getEditors() {
        final ArrayList<WorldEditor> editors = new ArrayList<WorldEditor>();
        Displays.pendInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (IEditorReference editor : AWorkbench.getEditors((String)WorldEditor.EDITOR_ID)) {
                    editors.add((WorldEditor)editor.getEditor(false));
                }
            }
        });
        return editors;
    }

    public static void closeAll() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (IEditorReference editor : AWorkbench.getEditors((String)WorldEditor.EDITOR_ID)) {
                    AWorkbench.getActivePage().closeEditor(editor.getEditor(false), false);
                }
            }
        });
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public void dispose() {
        if (this.worldXWidgetActionPage != null && this.worldXWidgetActionPage.getWorldComposite() != null) {
            this.worldXWidgetActionPage.getWorldComposite().disposeComposite();
        }
        super.dispose();
    }

    @Override
    public String getCurrentTitleLabel() {
        return this.worldXWidgetActionPage.getCurrentTitleLabel();
    }

    @Override
    public void setTableTitle(String title, boolean warning) {
        this.worldXWidgetActionPage.setTableTitle(title, warning);
    }

    public boolean isDirty() {
        return false;
    }

    protected void addPages() {
        try {
            OseeStatusContributionItemFactory.addTo((MultiPageEditorPart)this, (boolean)true);
            IWorldEditorProvider provider = this.getWorldEditorProvider();
            this.setPartName(provider.getSelectedName(WorldSearchItem.SearchType.Search));
            if (this.getWorldEditorInput().isReload()) {
                this.createReloadTab();
                this.setActivePage(0);
            } else {
                if (provider instanceof IWorldEditorConsumer) {
                    ((IWorldEditorConsumer)((Object)provider)).setWorldEditor(this);
                }
                this.createMainTab();
                this.createMetricsTab();
                this.setActivePage("org.eclipse.osee.ats.ide.actionPage");
            }
            if (!this.getWorldEditorInput().isReload()) {
                this.getSite().setSelectionProvider((ISelectionProvider)this.getWorldComposite().getXViewer());
                HelpUtil.setHelp((Control)this.worldXWidgetActionPage.getWorldComposite().getControl(), (HelpContext)AtsHelpContext.WORLD_VIEW);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public WorldComposite getWorldComposite() {
        return this.worldXWidgetActionPage.getWorldComposite();
    }

    public WorldXWidgetActionPage getWorldXWidgetActionPage() {
        return this.worldXWidgetActionPage;
    }

    public void setEditorTitle(final String str) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorldEditor.this.setPartName(str);
                WorldEditor.this.firePropertyChange(1);
            }
        });
    }

    @Override
    public IWorldEditorProvider getWorldEditorProvider() {
        WorldEditorInput worldEditorInput = this.getWorldEditorInput();
        worldEditorInput.setEditor(this);
        return worldEditorInput.getIWorldEditorProvider();
    }

    public WorldEditorInput getWorldEditorInput() {
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof WorldEditorInput)) {
            throw new OseeArgumentException("Editor Input not WorldEditorInput", new Object[0]);
        }
        return (WorldEditorInput)editorInput;
    }

    @Override
    public void reSearch() {
        this.worldXWidgetActionPage.reSearch();
    }

    public boolean isReloadTabShown() {
        return this.getActivePageInstance() instanceof WorldReloadTab;
    }

    private void createReloadTab() throws PartInitException {
        this.addPage((IFormPage)new WorldReloadTab(this, (WorldEditorReloadProvider)this.getWorldEditorProvider()));
    }

    private void createMainTab() throws PartInitException {
        this.worldXWidgetActionPage = new WorldXWidgetActionPage(this);
        this.addPage((IFormPage)this.worldXWidgetActionPage);
    }

    private void createMetricsTab() {
        Composite comp = WorkflowEditor.createCommonPageComposite(this.getContainer());
        new AtsMetricsComposite(this, comp, 0);
        int metricsPageIndex = this.addPage((Control)comp);
        this.setPageText(metricsPageIndex, "Metrics");
    }

    public List<Artifact> getLoadedArtifacts() {
        if (this.worldXWidgetActionPage == null || this.worldXWidgetActionPage.getWorldComposite() == null) {
            return Collections.emptyList();
        }
        return this.worldXWidgetActionPage.getWorldComposite().getLoadedArtifacts();
    }

    @Override
    public Collection<? extends Artifact> getMetricsWorkItems() {
        return this.getLoadedArtifacts();
    }

    @Override
    public IAtsVersion getMetricsVersion() {
        IAtsVersion verArt = this.getWorldEditorProvider().getTargetedVersionArtifact();
        if (verArt != null) {
            return verArt;
        }
        for (Artifact artifact : this.getLoadedArtifacts()) {
            IAtsWorkItem workItem = (IAtsWorkItem)artifact;
            if (!(artifact instanceof IAtsWorkItem) || !AtsApiService.get().getVersionService().hasTargetedVersion(workItem)) continue;
            return AtsApiService.get().getVersionService().getTargetedVersion(workItem);
        }
        return null;
    }

    @Override
    public double getManHoursPerDayPreference() {
        return WorldComposite.getManHoursPerDayPreference(this.getLoadedArtifacts());
    }

    @Override
    public void reflow() {
        this.getWorldXWidgetActionPage().reflow();
    }

    @Override
    public void createToolBarPulldown(Menu menu) {
        new MenuItem(menu, 2);
        try {
            for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
                for (Action action : item.getWorldEditorMenuActions(this.getWorldEditorProvider(), this)) {
                    this.actionToMenuItem(menu, action, 8);
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void onDirtied() {
    }

    public boolean isTaskEditor() {
        return this.getWorldEditorInput().getIWorldEditorProvider() instanceof TaskEditorProvider;
    }

    protected MenuItem actionToMenuItem(Menu menu, final Action action, final int buttonType) {
        final Action fAction = action;
        MenuItem item = new MenuItem(menu, buttonType);
        item.setText(action.getText());
        if (action.getImageDescriptor() != null) {
            item.setImage(action.getImageDescriptor().createImage());
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (buttonType == 32) {
                    action.setChecked(!action.isChecked());
                }
                fAction.run();
            }
        });
        return item;
    }

    public void reflowParameterSection() {
        this.worldXWidgetActionPage.getManagedForm().reflow(true);
    }
}

