/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.MembersLabelProvider;
import org.eclipse.osee.ats.ide.workflow.goal.MembersManager;
import org.eclipse.osee.ats.ide.workflow.goal.MembersViewerSorter;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;

public class GoalManager
extends MembersManager<GoalArtifact> {
    public GoalArtifact promptChangeGoalOrder(Artifact artifact) {
        if (!this.isHasCollector(artifact)) {
            AWorkbench.popup((String)String.format("No Goal set for artifact [%s]", artifact));
            return null;
        }
        Collection<Artifact> goals = this.getCollectors(artifact, false);
        GoalArtifact goal = null;
        if (goals.size() == 1) {
            goal = (GoalArtifact)goals.iterator().next();
        } else if (goals.size() > 1) {
            FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog("Select Goal", "Artifact has multiple Goals\n\nSelect Goal to change order", goals, (ITreeContentProvider)new ArrayTreeContentProvider(), (ILabelProvider)new MembersLabelProvider(), (ViewerComparator)new MembersViewerSorter());
            dialog.setMultiSelect(false);
            if (dialog.open() == 0) {
                goal = (GoalArtifact)dialog.getSelectedFirst();
            } else {
                return null;
            }
        }
        return this.promptChangeMemberOrder(goal, artifact);
    }

    @Override
    public RelationTypeSide getMembersRelationTypeSide() {
        return AtsRelationTypes.Goal_Member;
    }

    @Override
    public String getItemName() {
        return "Goal";
    }

    @Override
    public ArtifactTypeToken getArtifactType() {
        return AtsArtifactTypes.Goal;
    }

    @Override
    public String getMemberOrder(GoalArtifact goalArt, Artifact member) {
        return AtsApiService.get().getGoalMembersCache().getMemberOrder(goalArt, member);
    }
}

