/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr.taskest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstUtil;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.TaskEstNameProvider;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TaskEstOperations {
    private final AtsApi atsApi;
    private final AtsWorkDefinitionToken taskWorkDef;
    private final TaskEstNameProvider nameProvider;

    public TaskEstOperations(AtsApi atsApi, AtsWorkDefinitionToken taskWorkDef, TaskEstNameProvider nameProvider) {
        this.atsApi = atsApi;
        this.taskWorkDef = taskWorkDef;
        this.nameProvider = nameProvider;
    }

    public NewTaskSet createCannedTasks(IAtsTeamWorkflow teamWf, Collection<TaskEstDefinition> items) {
        NewTaskSet newTaskSet = NewTaskSet.create((String)"Create Task(s)", (String)this.atsApi.getUserService().getCurrentUserId());
        NewTaskData newTaskData = NewTaskData.create((NewTaskSet)newTaskSet, (IAtsTeamWorkflow)teamWf);
        for (TaskEstDefinition ted : items) {
            if (!ted.isChecked()) continue;
            newTaskData.setTaskWorkDef(this.taskWorkDef);
            JaxAtsTask task = new JaxAtsTask();
            String name = this.nameProvider.getTaskName(ted);
            task.setName(name);
            task.addAttributes((AttributeTypeToken)CoreAttributeTypes.StaticId, Arrays.asList(ted.getId(), TaskEstUtil.TASK_EST_STATIC_ID, TaskEstUtil.TASK_EST_CANNED));
            if (Strings.isValid((String)ted.getDescription())) {
                task.addAttribute((AttributeTypeToken)AtsAttributeTypes.Description, (Object)ted.getDescription());
            }
            task.setCreatedByUserId(this.atsApi.getUserService().getCurrentUserId());
            task.setCreatedDate(new Date());
            task.setAssigneeAccountIds(ted.getAssigneeAccountIds());
            task.addRelation(AtsRelationTypes.Derive_From, new long[]{teamWf.getId()});
            newTaskData.add(task);
        }
        newTaskSet = this.atsApi.getTaskService().createTasks(newTaskSet);
        return newTaskSet;
    }
}

