/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IArtifactResolver;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class ArtifactResolverImpl
implements IArtifactResolver {
    public ArtifactId get(IAtsObject atsObject) {
        if (atsObject instanceof Artifact) {
            return AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        }
        Artifact artifact = (Artifact)AtsApiService.get().getQueryService().getArtifact(atsObject.getId());
        return artifact;
    }

    public <A extends ArtifactId> A get(IAtsWorkItem workItem, Class<?> clazz) {
        ArtifactId artifact = this.get((IAtsObject)workItem);
        if (clazz.isInstance(artifact)) {
            return (A)artifact;
        }
        return null;
    }

    public <A extends ArtifactId> List<A> get(Collection<? extends IAtsWorkItem> workItems, Class<?> clazz) {
        Assert.isNotNull(workItems, (String)"Work Items can not be null");
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            Artifact artifact = (Artifact)this.get(iAtsWorkItem, clazz);
            if (artifact == null) continue;
            arts.add(artifact);
        }
        return arts;
    }

    public ArtifactTypeToken getArtifactType(IAtsWorkItem workItem) {
        Assert.isNotNull((Object)workItem, (String)"Work Item can not be null");
        return AtsApiService.get().getQueryServiceIde().getArtifact(workItem).getArtifactType();
    }
}

