/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.ILogStorageProvider;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.log.AtsLogUtility;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractAtsArtifact;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultBrowserHyperCmd;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;

public class Overview {
    public static final String normalColor = "#EEEEEE";
    private static final String activeColor = "#9CCCFF";
    public static final String errorColor = "#FFD6AC";
    public static final String subscribedColor = "#FFCCAA";
    public static final String labelColor = "darkcyan";
    private StringBuilder html;
    public static final String labelFont = "<font color=\"darkcyan\" face=\"Arial\" size=\"-1\">";
    public static final int TABLE_WIDTH = 95;
    public boolean showTasks = false;

    public Overview() {
        this.clearHtml();
    }

    public void clearHtml() {
        this.html = new StringBuilder(1000);
    }

    public String getPage() {
        return "<html><body>\n" + this.html + "\n</body></html>";
    }

    public String getLabelValue(String label, String value) {
        String valueStr = AHTML.textToHtml((String)value);
        return String.valueOf(Overview.getLabel(label)) + valueStr;
    }

    public static String getLabel(String label) {
        return AHTML.getLabelStr((String)labelFont, (String)(String.valueOf(label) + ": "));
    }

    public void addTable(String ... strs) {
        this.addTable(strs, 100);
    }

    public void addTable(String[] strs, int width) {
        if (strs.length == 1) {
            this.html.append(AHTML.simpleTable((String)strs[0]));
        } else {
            this.html.append(AHTML.multiColumnTable((int)width, (String[])strs));
        }
    }

    public void addHeader(AbstractWorkflowArtifact awa, PreviewStyle ... styles) {
        this.startBorderTable(100, false, "");
        this.addRelationsBlock(awa);
        this.addNotes(awa);
        this.addTable(this.getLabelValue("Title", awa.getName()));
        this.html.append(AHTML.multiColumnTable((String[])new String[]{String.valueOf(AHTML.getLabelStr((String)labelFont, (String)"State: ")) + awa.getStateMgr().getCurrentStateName(), String.valueOf(AHTML.getLabelStr((String)labelFont, (String)"Type: ")) + awa.getArtifactTypeName(), String.valueOf(AHTML.getLabelStr((String)labelFont, (String)"Id: ")) + awa.getAtsId()}));
        this.addTable(this.getLabelValue("Originator", awa.getCreatedBy().getName()), this.getLabelValue("Creation Date", DateUtil.getMMDDYYHHMM((Date)awa.getCreatedDate())));
        if (awa.isTeamWorkflow()) {
            this.addTable(this.getLabelValue("Team", ((TeamWorkFlowArtifact)awa).getTeamName()), this.getLabelValue("Assignees", AtsObjects.toString((String)"; ", (Collection)awa.getStateMgr().getAssignees())));
        } else {
            this.addTable(this.getLabelValue("Assignees", AtsObjects.toString((String)"; ", (Collection)awa.getStateMgr().getAssignees())));
        }
        this.addTable(this.getLabelValue("Description", awa.getDescription()));
        if (awa.isCancelled()) {
            this.addTable(this.getLabelValue("Cancelled From", awa.getCancelledFromState()));
            this.addTable(this.getLabelValue("Cancellation Reason", awa.getCancelledReason()));
        }
        if (awa.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.Task)) {
            AbstractWorkflowArtifact parentArt = ((TaskArtifact)awa).getParentAWA();
            if (parentArt != null) {
                this.html.append(AHTML.multiColumnTable((String[])new String[]{String.valueOf(AHTML.getLabelStr((String)labelFont, (String)"Parent Workflow: ")) + parentArt.getName()}));
                this.html.append(AHTML.multiColumnTable((String[])new String[]{String.valueOf(AHTML.getLabelStr((String)labelFont, (String)"Parent State: ")) + ((TaskArtifact)awa).getStateMgr().getCurrentStateName()}));
            }
            this.html.append(AHTML.multiColumnTable((String[])new String[]{String.valueOf(AHTML.getLabelStr((String)labelFont, (String)"Task Owner: ")) + AtsObjects.toString((String)"; ", (Collection)awa.getStateMgr().getAssignees())}));
        }
        this.endBorderTable();
    }

    public void addFooter(AbstractWorkflowArtifact sma, PreviewStyle ... styles) {
        this.html.append(AHTML.newline());
        if (PreviewStyle.contains(styles, PreviewStyle.HYPEROPEN)) {
            this.html.append("Start OSEE, select the ATS perspective and search by the Id shown.");
        }
    }

    public void addRelationsBlock(AbstractAtsArtifact artifact) {
        this.addRelationTable("Is Superceded By", CoreRelationTypes.Supercedes_Supercedes, artifact);
        this.addRelationTable("Supercedes", CoreRelationTypes.Supercedes_SupercededBy, artifact);
        this.addRelationTable("Supports", CoreRelationTypes.SupportingInfo_IsSupportedBy, artifact);
        this.addRelationTable("Is Supported By", CoreRelationTypes.SupportingInfo_SupportingInfo, artifact);
    }

    public void addNotes(AbstractWorkflowArtifact artifact) {
        String notesHtml = AtsApiService.get().getWorkItemService().getStateNoteService().getTable((IAtsWorkItem)artifact, null);
        if (notesHtml.equals("")) {
            return;
        }
        this.html.append(notesHtml);
    }

    public static String getGenericArtifactTable(String name, Collection<Artifact> arts) {
        return Overview.getGenericArtifactTable(name, arts, 100);
    }

    public static String getGenericArtifactTable(String name, Collection<Artifact> arts, int width) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(AHTML.addSpace((int)1)) + Overview.getLabel(name));
        if (arts.size() > 0) {
            builder.append("<TABLE BORDER=\"1\" align=\"center\" cellspacing=\"1\" cellpadding=\"3%\" width=\"" + width + "%\"><THEAD><TR><TH>Type</TH>" + "<TH>Name</TH></THEAD></TR>");
            for (Artifact art : arts) {
                builder.append("<TR>");
                builder.append("<TD>" + art.getArtifactTypeName() + "</TD>");
                builder.append("<TD>" + Overview.getOpenHyperlinkHtml(art) + "</TD>");
                builder.append("</TR>");
            }
            builder.append("</TABLE>");
        }
        return builder.toString();
    }

    public void addRelationTable(String name, RelationTypeSide side, Artifact parent) {
        try {
            List arts = parent.getRelatedArtifacts(side);
            if (arts.isEmpty()) {
                return;
            }
            this.startBorderTable(false, name);
            this.html.append(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Type", "Name", "Rationale"}));
            for (Artifact art : arts) {
                String rationale = "";
                RelationLink link = (RelationLink)parent.getRelations(side, art).iterator().next();
                if (!link.getRationale().equals("")) {
                    rationale = link.getRationale();
                }
                String hyperStr = Overview.getOpenHyperlinkHtml(art);
                this.html.append(AHTML.addRowMultiColumnTable((String[])new String[]{art.getArtifactTypeName(), hyperStr, rationale}));
            }
            this.endBorderTable();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void addTeams(Collection<TeamWorkFlowArtifact> teams) {
        this.startBorderTable(95, false, "Team Workflows");
        StringBuffer sb = new StringBuffer(AHTML.beginMultiColumnTable((int)100, (int)1));
        sb.append(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Type", "State"}, (Integer[])new Integer[]{70, 150}));
        ArrayList<AHTML.CellItem> cells = new ArrayList<AHTML.CellItem>();
        for (TeamWorkFlowArtifact team : teams) {
            cells.add(new AHTML.CellItem(Overview.getOpenHyperlinkHtml(team)));
            cells.add(new AHTML.CellItem(team.getStateMgr().getCurrentStateName()));
            sb.append(AHTML.addRowMultiColumnTable(cells));
            cells.clear();
        }
        sb.append(AHTML.endMultiColumnTable());
        this.html.append(sb.toString());
        this.endBorderTable();
    }

    public static String getOpenHyperlinkHtml(Artifact art) {
        return Overview.getOpenHyperlinkHtml(art.getName(), art);
    }

    public static String getOpenHyperlinkHtml(String name, Artifact art) {
        return AHTML.getHyperlink((String)XResultBrowserHyperCmd.getHyperCmdStr((XResultBrowserHyperCmd)XResultBrowserHyperCmd.openAction, (String)art.getIdString()), (String)name);
    }

    public void addLog(AbstractWorkflowArtifact artifact) {
        IAtsLog artifactLog = artifact.getLog();
        if (artifactLog != null && artifactLog.getLogItems().size() > 0) {
            AtsLogUtility.getTable((IAtsLog)artifactLog, (ILogStorageProvider)AtsApiService.get().getLogFactory().getLogProvider((IAtsWorkItem)artifact, AtsApiService.get().getAttributeResolver()), (IAtsUserService)AtsApiService.get().getUserService());
        }
    }

    public void startStateBorderTable(boolean active, String name, String assignee) {
        if (Strings.isValid((String)assignee)) {
            this.startBorderTable(active, String.format("%s (%s)", name, assignee));
        } else {
            this.startBorderTable(active, String.format("%s", name));
        }
    }

    public void startBorderTable(boolean active, String caption) {
        this.html.append(AHTML.startBorderTable((int)95, (String)(active ? activeColor : normalColor), (String)caption));
    }

    public void startBorderTable(int width, boolean active, String caption) {
        this.html.append(AHTML.startBorderTable((int)width, (String)(active ? activeColor : normalColor), (String)caption));
    }

    public void startBorderTable(int width, String caption, String backgroundColor) {
        this.html.append(AHTML.startBorderTable((int)width, (String)backgroundColor, (String)caption));
    }

    public void endBorderTable() {
        this.html.append(AHTML.endBorderTable());
    }

    public boolean isShowTasks() {
        return this.showTasks;
    }

    public void setShowTasks(boolean showTasks) {
        this.showTasks = showTasks;
    }

    public static enum PreviewStyle {
        NONE,
        MAP,
        TASKS,
        NOTES,
        LOG,
        HYPEROPEN,
        NO_SUBSCRIBE_OR_FAVORITE;


        public static boolean contains(PreviewStyle[] styles, PreviewStyle style) {
            PreviewStyle[] previewStyleArray = styles;
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                PreviewStyle st = previewStyleArray[n2];
                if (st.equals((Object)style)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

