/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.navigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SearchNavigateItem;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.search.navigate.ImportSavedSearchNavigateItem;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.swt.Displays;

public class SavedActionSearchNavigateItem
extends XNavigateItem {
    private static SavedActionSearchNavigateItem topNavigateItem;
    public static final XNavItemCat SAVED_ACTION_SEARCHES;

    static {
        SAVED_ACTION_SEARCHES = new XNavItemCat("Saved Action Searches");
    }

    public SavedActionSearchNavigateItem(XNavItemCat category) {
        super(SAVED_ACTION_SEARCHES.getName(), (OseeImage)AtsImage.SEARCH, new XNavItemCat[]{category});
        topNavigateItem = this;
        this.refresh();
    }

    public void refresh() {
        if (topNavigateItem != null) {
            Thread refresh = new Thread(((Object)((Object)topNavigateItem)).getClass().getSimpleName()){

                @Override
                public void run() {
                    SavedActionSearchNavigateItem.this.load();
                    if (SavedActionSearchNavigateItem.this.refresher != null) {
                        Displays.ensureInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SavedActionSearchNavigateItem.this.refresher.refresh((XNavigateItem)topNavigateItem);
                            }
                        });
                    }
                }
            };
            refresh.start();
        }
    }

    public static void refreshItems() {
        topNavigateItem.refresh();
    }

    private void load() {
        try {
            AtsApiIde atsApi = AtsApiService.get();
            if (topNavigateItem.getChildren() != null) {
                topNavigateItem.getChildren().clear();
            }
            topNavigateItem.addChild(new ImportSavedSearchNavigateItem());
            HashSet<Long> ids = new HashSet<Long>();
            for (IAtsWorldEditorItem worldEditorItem : AtsWorldEditorItems.getItems()) {
                for (AtsSearchWorkflowSearchItem item : worldEditorItem.getSearchWorkflowSearchItems()) {
                    List savedSearches = atsApi.getQueryService().getSavedSearches(item.getNamespace());
                    for (AtsSearchData data : savedSearches) {
                        if (ids.contains(data.getId())) continue;
                        AtsSearchWorkflowSearchItem searchItem = item.copy();
                        searchItem.setSavedData(data);
                        SearchNavigateItem navItem = new SearchNavigateItem((WorldSearchItem)searchItem, SAVED_ACTION_SEARCHES);
                        navItem.setName(String.valueOf(item.getShortNamePrefix()) + ": " + data.getSearchName());
                        ids.add(data.getId());
                        topNavigateItem.addChild(navItem);
                    }
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(SavedActionSearchNavigateItem.class, (Level)Level.WARNING, (String)"Error populating searches", (Throwable)ex);
        }
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Arrays.asList(CoreUserGroups.Everyone);
    }
}

