/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.StateListAndTitleDialog;
import org.eclipse.osee.ats.ide.workflow.review.NewDecisionReviewJob;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class CreateDecisionReviewAction
extends Action {
    private final WorkflowEditor editor;

    public CreateDecisionReviewAction(WorkflowEditor editor) {
        super("Create Decision Review");
        this.editor = editor;
        this.setToolTipText(this.getText());
    }

    public void run() {
        try {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)this.editor.getWorkItem();
            StateListAndTitleDialog dialog = new StateListAndTitleDialog("Create Decision Review", "Select state to that review will be associated with (optional).", AtsApiService.get().getWorkDefinitionService().getStateNames(teamWf.getWorkDefinition()));
            if (dialog.open() == 0) {
                if (!Strings.isValid((String)dialog.getReviewTitle())) {
                    AWorkbench.popup((String)"ERROR", (String)"Must enter review title");
                    return;
                }
                NewDecisionReviewJob job = new NewDecisionReviewJob(teamWf, null, dialog.getReviewTitle(), dialog.getSelectedState(), null, AtsApiService.get().getReviewService().getDefaultDecisionReviewOptions(), null, new Date(), AtsApiService.get().getUserService().getCurrentUser());
                job.setUser(true);
                job.setPriority(30);
                job.schedule();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.DECISION_REVIEW);
    }
}

